/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.datacollection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.internal.collection.DatacollectionConfigVisitor;

@XmlRootElement(name="ipList", namespace="http://xmlns.opennms.org/xsd/config/datacollection")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="datacollection-config.xsd")
public class IpList
implements Serializable {
    private static final long serialVersionUID = -6384287387760637940L;
    @XmlElement(name="ipAddr")
    private List<String> m_ipAddresses = new ArrayList<String>();
    @XmlElement(name="ipAddrMask")
    private List<String> m_ipAddressMasks = new ArrayList<String>();

    public List<String> getIpAddresses() {
        if (this.m_ipAddresses == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_ipAddresses);
    }

    public void setIpAddresses(List<String> ipAddrs) {
        this.m_ipAddresses = new ArrayList<String>(ipAddrs);
    }

    public void addIpAddress(String ipAddr) throws IndexOutOfBoundsException {
        this.m_ipAddresses.add(ipAddr.intern());
    }

    public boolean removeIpAddress(String ipAddr) {
        return this.m_ipAddresses.remove(ipAddr);
    }

    public List<String> getIpAddressMasks() {
        if (this.m_ipAddressMasks == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_ipAddressMasks);
    }

    public void setIpAddressMasks(List<String> masks) {
        this.m_ipAddressMasks = new ArrayList<String>(masks);
    }

    public void addIpAddressMask(String mask) throws IndexOutOfBoundsException {
        this.m_ipAddressMasks.add(mask.intern());
    }

    public boolean removeIpAddressMask(String mask) {
        return this.m_ipAddressMasks.remove(mask);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_ipAddressMasks == null ? 0 : this.m_ipAddressMasks.hashCode());
        result = 31 * result + (this.m_ipAddresses == null ? 0 : this.m_ipAddresses.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpList)) {
            return false;
        }
        IpList other = (IpList)obj;
        if (this.m_ipAddressMasks == null ? other.m_ipAddressMasks != null : !this.m_ipAddressMasks.equals(other.m_ipAddressMasks)) {
            return false;
        }
        return !(this.m_ipAddresses == null ? other.m_ipAddresses != null : !this.m_ipAddresses.equals(other.m_ipAddresses));
    }

    public String toString() {
        return "IpList [ipAddresses=" + String.valueOf(this.m_ipAddresses) + ", ipAddressMasks=" + String.valueOf(this.m_ipAddressMasks) + "]";
    }

    public void visit(DatacollectionConfigVisitor visitor) {
        visitor.visitIpList(this);
        visitor.visitIpListComplete();
    }
}

