/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire;

import java.io.IOException;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.util.IOExceptionSupport;

public class OpenWireUtil {
    static final String jmsPackageToReplace = "jakarta.jms";
    static final String jmsPackageToUse = "javax.jms";

    public static void validateIsThrowable(Class<?> clazz) {
        if (!Throwable.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class " + clazz + " is not assignable to Throwable");
        }
    }

    public static void validateBufferSize(OpenWireFormat wireFormat, int size2) throws IOException {
        OpenWireUtil.validateLessThanFrameSize(wireFormat, size2);
        if (wireFormat.isMaxFrameSizeEnabled() && (long)size2 > wireFormat.getMaxFrameSize()) {
            throw IOExceptionSupport.createFrameSizeException(size2, wireFormat.getMaxFrameSize());
        }
    }

    private static void validateLessThanFrameSize(OpenWireFormat wireFormat, int size2) throws IOException {
        OpenWireFormat.MarshallingContext context = wireFormat.getMarshallingContext();
        if (context == null || context.getFrameSize() < 0) {
            return;
        }
        context.increment(size2);
        if (context.getEstimatedAllocated() > context.getFrameSize()) {
            throw IOExceptionSupport.createFrameSizeBufferException(context.getEstimatedAllocated(), context.getFrameSize());
        }
    }

    public static String convertJmsPackage(String className) {
        if (className != null && className.startsWith(jmsPackageToReplace)) {
            return className.replace(jmsPackageToReplace, jmsPackageToUse);
        }
        return className;
    }
}

