/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.scheduler;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.netmgt.scheduler.PriorityReadyRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyPriorityExecutor
implements PausableFiber {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyPriorityExecutor.class);
    private final String m_parent;
    private final ExecutorService priorityJobPoolExecutor;
    private final PriorityBlockingQueue<PriorityReadyRunnable> priorityQueue;
    private final ExecutorService m_worker = Executors.newSingleThreadExecutor();
    private volatile int m_status;

    public LegacyPriorityExecutor(String parent, Integer poolSize, Integer queueSize) {
        this.m_parent = parent;
        this.m_status = 0;
        this.priorityJobPoolExecutor = Executors.newFixedThreadPool(poolSize, (ThreadFactory)new LogPreservingThreadFactory(parent, poolSize.intValue()));
        this.priorityQueue = new PriorityBlockingQueue<PriorityReadyRunnable>(queueSize, Comparator.comparing(PriorityReadyRunnable::getPriority));
    }

    public synchronized void addPriorityReadyRunnable(PriorityReadyRunnable job) {
        this.priorityQueue.add(job);
        LOG.info("addPriorityReadyRunnable: Added {}, total in queue: {}", (Object)job.getInfo(), (Object)this.priorityQueue.size());
    }

    public synchronized void pause() {
        if (this.m_status == 6) {
            return;
        }
        this.m_status = 5;
        this.notifyAll();
    }

    public synchronized void resume() {
        if (this.m_status == 2) {
            return;
        }
        this.m_status = 7;
        this.notifyAll();
    }

    public void start() {
        this.m_worker.execute(() -> {
            block14: {
                LegacyPriorityExecutor legacyPriorityExecutor = this;
                synchronized (legacyPriorityExecutor) {
                    this.m_status = 2;
                }
                LOG.info("run: Priority Executor {} running", (Object)this.m_parent);
                try {
                    while (true) {
                        LOG.debug("Taking");
                        PriorityReadyRunnable executable = this.priorityQueue.take();
                        LOG.debug("Taked: {}", (Object)executable.getInfo());
                        while (this.m_status == 5 || this.m_status == 6) {
                            if (this.m_status == 5) {
                                LOG.info("run: pausing.");
                            }
                            this.m_status = 6;
                            LegacyPriorityExecutor legacyPriorityExecutor2 = this;
                            synchronized (legacyPriorityExecutor2) {
                                this.wait();
                            }
                        }
                        if (this.m_status == 3) {
                            LOG.info("run: status = {}, time to exit", (Object)this.m_status);
                            break block14;
                        }
                        if (this.m_status == 7) {
                            LOG.info("run: resuming.");
                            this.m_status = 2;
                        }
                        if (executable.isReady()) {
                            this.priorityJobPoolExecutor.execute(executable);
                            LOG.debug("run: added to priority job executor thread pool: {}", (Object)executable.getInfo());
                            if (!(this.priorityJobPoolExecutor instanceof ThreadPoolExecutor)) continue;
                            ThreadPoolExecutor e = (ThreadPoolExecutor)this.priorityJobPoolExecutor;
                            String ratio = String.format("%.3f", e.getTaskCount() > 0L ? BigDecimal.valueOf(e.getCompletedTaskCount()).divide(BigDecimal.valueOf(e.getTaskCount()), 2, RoundingMode.DOWN) : Integer.valueOf(0));
                            LOG.debug("thread pool statistics: activeCount={}, taskCount={}, completedTaskCount={}, completedRatio={}, poolSize={}", new Object[]{e.getActiveCount(), e.getTaskCount(), e.getCompletedTaskCount(), ratio, e.getPoolSize()});
                            continue;
                        }
                        executable.setPriority(executable.getPriority() + 1);
                        this.addPriorityReadyRunnable(executable);
                    }
                }
                catch (InterruptedException e) {}
                {
                }
            }
        });
    }

    public synchronized void stop() {
        if (this.m_status == 3) {
            return;
        }
        this.m_status = 3;
        this.priorityJobPoolExecutor.shutdown();
        this.m_worker.shutdown();
    }

    public synchronized int getStatus() {
        if (this.m_worker.isShutdown()) {
            this.m_status = 4;
        }
        return this.m_status;
    }

    public String getName() {
        return this.priorityJobPoolExecutor.toString();
    }
}

