/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.timeseries.immutables;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.StringJoiner;
import org.opennms.integration.api.v1.timeseries.Aggregation;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.TimeSeriesFetchRequest;

public class ImmutableTimeSeriesFetchRequest
implements TimeSeriesFetchRequest,
Serializable {
    private final Metric metric;
    private final Instant start;
    private final Instant end;
    private final Duration step;
    private final Aggregation aggregation;

    private ImmutableTimeSeriesFetchRequest(Metric metric, Instant start, Instant end, Duration step, Aggregation aggregation) {
        this.metric = Objects.requireNonNull(metric, "metric cannot be null.");
        this.start = Objects.requireNonNull(start, "start cannot be null");
        this.end = Objects.requireNonNull(end, "end cannot be null");
        this.step = Objects.requireNonNull(step, "step cannot be null");
        this.aggregation = Objects.requireNonNull(aggregation, "aggregation cannot be null");
    }

    public Metric getMetric() {
        return this.metric;
    }

    public Instant getStart() {
        return this.start;
    }

    public Instant getEnd() {
        return this.end;
    }

    public Duration getStep() {
        return this.step;
    }

    public Aggregation getAggregation() {
        return this.aggregation;
    }

    public String toString() {
        return new StringJoiner(", ", ImmutableTimeSeriesFetchRequest.class.getSimpleName() + "[", "]").add("metric=" + this.metric).add("start=" + this.start).add("end=" + this.end).add("step=" + this.step).add("aggregation=" + this.aggregation).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeSeriesFetchRequest)) {
            return false;
        }
        TimeSeriesFetchRequest that = (TimeSeriesFetchRequest)o;
        return Objects.equals(this.metric, that.getMetric()) && Objects.equals(this.start, that.getStart()) && Objects.equals(this.end, that.getEnd()) && Objects.equals(this.step, that.getStep()) && this.aggregation == that.getAggregation();
    }

    public int hashCode() {
        return Objects.hash(this.metric, this.start, this.end, this.step, this.aggregation);
    }

    public static ImmutableTimeSeriesFetchRequestBuilder builder() {
        return new ImmutableTimeSeriesFetchRequestBuilder();
    }

    public static class ImmutableTimeSeriesFetchRequestBuilder {
        private Metric metric;
        private Instant start;
        private Instant end;
        private Duration step;
        private Aggregation aggregation;

        ImmutableTimeSeriesFetchRequestBuilder() {
        }

        public ImmutableTimeSeriesFetchRequestBuilder metric(Metric metric) {
            this.metric = metric;
            return this;
        }

        public ImmutableTimeSeriesFetchRequestBuilder start(Instant start) {
            this.start = start;
            return this;
        }

        public ImmutableTimeSeriesFetchRequestBuilder end(Instant end) {
            this.end = end;
            return this;
        }

        public ImmutableTimeSeriesFetchRequestBuilder step(Duration step) {
            this.step = step;
            return this;
        }

        public ImmutableTimeSeriesFetchRequestBuilder aggregation(Aggregation aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        public ImmutableTimeSeriesFetchRequest build() {
            return new ImmutableTimeSeriesFetchRequest(this.metric, this.start, this.end, this.step, this.aggregation);
        }

        public String toString() {
            return "ImmutableTimeSeriesFetchRequest.ImmutableTimeSeriesFetchRequestBuilder(metric=" + this.metric + ", start=" + this.start + ", end=" + this.end + ", step=" + this.step + ", aggregation=" + this.aggregation + ")";
        }
    }
}

