/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.Array;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.Lane;

public class Sfp {
    public final long module_id;
    public final long module_num_lanes;
    public final long module_supply_voltage;
    public final Integer module_temperature;
    public final Array<Lane> lanes;

    public Sfp(ByteBuf buffer) throws InvalidPacketException {
        this.module_id = BufferUtils.uint32((ByteBuf)buffer);
        this.module_num_lanes = BufferUtils.uint32((ByteBuf)buffer);
        this.module_supply_voltage = BufferUtils.uint32((ByteBuf)buffer);
        this.module_temperature = BufferUtils.sint32((ByteBuf)buffer);
        this.lanes = new Array<Object>(buffer, Optional.empty(), Lane::new);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("module_id", this.module_id).add("module_num_lanes", this.module_num_lanes).add("module_supply_voltage", this.module_supply_voltage).add("module_temperature", (Object)this.module_temperature).add("lanes", this.lanes).toString();
    }

    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeInt64("module_id", this.module_id);
        bsonWriter.writeInt64("module_num_lanes", this.module_num_lanes);
        bsonWriter.writeInt64("module_supply_voltage", this.module_supply_voltage);
        bsonWriter.writeInt32("module_temperature", this.module_temperature.intValue());
        bsonWriter.writeStartArray("lanes");
        for (Lane lane : this.lanes) {
            lane.writeBson(bsonWriter, enr);
        }
        bsonWriter.writeEndArray();
        bsonWriter.writeEndDocument();
    }
}

