/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;

public enum Ieee80211Version {
    a(1),
    b(2),
    g(3),
    n(4);

    public final int value;

    private Ieee80211Version(int value) {
        this.value = value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("value", this.value).toString();
    }

    public static Ieee80211Version from(ByteBuf buffer) throws InvalidPacketException {
        int value = (int)BufferUtils.uint32((ByteBuf)buffer);
        switch (value) {
            case 1: {
                return a;
            }
            case 2: {
                return b;
            }
            case 3: {
                return g;
            }
            case 4: {
                return n;
            }
        }
        throw new InvalidPacketException(buffer, "Unknown value: {}", value);
    }

    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeInt32(this.value);
    }
}

