/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.ie;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.Protocol;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.InformationElement;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.InformationElementXmlProvider;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Semantics;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.NullValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.InformationElementProvider;

public class InformationElementDatabase {
    private Map<Key, InformationElement> elements;

    public InformationElementDatabase(InformationElementXmlProvider informationElementXmlProvider) {
        this(new InformationElementProvider(), informationElementXmlProvider, new org.opennms.netmgt.telemetry.protocols.netflow.parser.netflow9.InformationElementProvider());
    }

    public InformationElementDatabase(Provider ... providers) {
        this.addProviders(providers);
    }

    private void addProviders(Provider ... providers) {
        AdderImpl adder = new AdderImpl();
        adder.add(Protocol.NETFLOW9, 0, NullValue::parser, "null", Optional.empty(), this);
        adder.add(Protocol.IPFIX, 0, NullValue::parser, "null", Optional.empty(), this);
        for (Provider provider : providers) {
            provider.load(adder);
        }
        this.elements = adder.getInformationElementMap();
    }

    public Optional<InformationElement> lookup(Protocol protocol, Optional<Long> enterpriseNumber, int informationElementIdentifier) {
        return Optional.ofNullable(this.elements.get(new Key(protocol, enterpriseNumber, informationElementIdentifier)));
    }

    public Optional<InformationElement> lookup(Protocol protocol, int informationElementIdentifier) {
        return this.lookup(protocol, Optional.empty(), informationElementIdentifier);
    }

    public static interface Provider {
        public void load(Adder var1);

        public InformationElementDatabase getDatabase();

        public void setDatabase(InformationElementDatabase var1);
    }

    private static class AdderImpl
    implements Adder {
        private final Map<Key, InformationElement> informationElementMap = new HashMap<Key, InformationElement>();

        private AdderImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(Key key, InformationElement element) {
            Map<Key, InformationElement> map = this.informationElementMap;
            synchronized (map) {
                Objects.requireNonNull(key);
                Objects.requireNonNull(element);
                this.informationElementMap.put(key, element);
            }
        }

        public Map<Key, InformationElement> getInformationElementMap() {
            return this.informationElementMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear(String source) {
            Map<Key, InformationElement> map = this.informationElementMap;
            synchronized (map) {
                this.informationElementMap.keySet().removeIf(key -> Objects.equals(key.source, source));
            }
        }
    }

    @FunctionalInterface
    public static interface ValueParserFactory {
        public InformationElement parser(InformationElementDatabase var1, String var2, Optional<Semantics> var3);
    }

    public static interface Adder {
        public void add(Key var1, InformationElement var2);

        default public void add(Protocol protocol, Optional<Long> enterpriseNumber, int informationElementNumber, ValueParserFactory parserFactory, String name, Optional<Semantics> semantics, InformationElementDatabase database) {
            this.add(new Key(protocol, enterpriseNumber, informationElementNumber), parserFactory.parser(database, name, semantics));
        }

        default public void add(Protocol protocol, Optional<Long> enterpriseNumber, int informationElementNumber, ValueParserFactory parserFactory, String name, Optional<Semantics> semantics, InformationElementDatabase database, String source) {
            this.add(new Key(protocol, enterpriseNumber, informationElementNumber, source), parserFactory.parser(database, name, semantics));
        }

        default public void add(Protocol protocol, int informationElementNumber, ValueParserFactory parserFactory, String name, Optional<Semantics> semantics, InformationElementDatabase database) {
            this.add(protocol, Optional.empty(), informationElementNumber, parserFactory, name, semantics, database);
        }

        default public void add(Protocol protocol, int informationElementNumber, ValueParserFactory parserFactory, String name, Semantics semantics, InformationElementDatabase database) {
            this.add(protocol, Optional.empty(), informationElementNumber, parserFactory, name, Optional.of(semantics), database);
        }

        public void clear(String var1);
    }

    public static class Key {
        private final Protocol protocol;
        private final Optional<Long> enterpriseNumber;
        private final Integer informationElementIdentifier;
        private String source;

        public Key(Protocol protocol, Optional<Long> enterpriseNumber, Integer informationElementNumber) {
            this(protocol, enterpriseNumber, informationElementNumber, null);
        }

        public Key(Protocol protocol, Optional<Long> enterpriseNumber, Integer informationElementNumber, String source) {
            this.protocol = Objects.requireNonNull(protocol);
            this.enterpriseNumber = Objects.requireNonNull(enterpriseNumber);
            this.informationElementIdentifier = Objects.requireNonNull(informationElementNumber);
            this.source = source;
        }

        public String toString() {
            return "Key{protocol=" + String.valueOf((Object)this.protocol) + ", enterpriseNumber=" + String.valueOf(this.enterpriseNumber) + ", informationElementIdentifier=" + this.informationElementIdentifier + ", source='" + this.source + "'}";
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.protocol == key.protocol && Objects.equals(this.enterpriseNumber, key.enterpriseNumber) && Objects.equals(this.informationElementIdentifier, key.informationElementIdentifier);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.protocol, this.enterpriseNumber, this.informationElementIdentifier});
        }
    }
}

