/*
 * Licensed to The OpenNMS Group, Inc (TOG) under one or more
 * contributor license agreements.  See the LICENSE.md file
 * distributed with this work for additional information
 * regarding copyright ownership.
 *
 * TOG licenses this file to You under the GNU Affero General
 * Public License Version 3 (the "License") or (at your option)
 * any later version.  You may not use this file except in
 * compliance with the License.  You may obtain a copy of the
 * License at:
 *
 *      https://www.gnu.org/licenses/agpl-3.0.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.  See the License for the specific
 * language governing permissions and limitations under the
 * License.
 */
package org.opennms.protocols.radius.monitor;

import java.net.InetSocketAddress;

import org.opennms.test.mock.MockUtil;
import org.tinyradius.packet.AccessRequest;
import org.tinyradius.packet.RadiusPacket;
import org.tinyradius.util.RadiusException;
import org.tinyradius.util.RadiusServer;

public class MockRadiusServer extends RadiusServer {
    @Override
    public String getSharedSecret(InetSocketAddress arg0) {
        return "testing123";
    }

    @Override
    public String getUserPassword(String usename) {
        return "password";
    }

    @Override
    public RadiusPacket accessRequestReceived(AccessRequest ar,
            InetSocketAddress client) throws RadiusException {
        MockUtil.println(ar.getAuthProtocol());
        return super.accessRequestReceived(ar, client);
    }

    @Override
    public void start(boolean hasAuth, boolean hasAcct) {
        MockUtil.println("Mock radius server starting");
        super.start(hasAuth, hasAcct);
    }

    @Override
    public void stop() {
        MockUtil.println("Stopping Radius server");
        super.stop();
    }

}
