/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.config.dao.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsonorg.JsonOrgModule;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.json.JSONObject;
import org.opennms.features.config.dao.api.ConfigData;
import org.opennms.features.config.dao.api.ConfigDefinition;
import org.opennms.features.config.dao.api.ConfigStoreDao;
import org.opennms.features.config.exception.ConfigAlreadyExistsException;
import org.opennms.features.config.exception.ConfigConversionException;
import org.opennms.features.config.exception.ConfigIOException;
import org.opennms.features.config.exception.ConfigNotFoundException;
import org.opennms.features.config.exception.ConfigRuntimeException;
import org.opennms.features.config.exception.SchemaConversionException;
import org.opennms.features.config.exception.SchemaNotFoundException;
import org.opennms.features.config.exception.ValidationException;
import org.opennms.features.distributed.kvstore.api.JsonStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JsonConfigStoreDaoImpl
implements ConfigStoreDao<JSONObject> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonConfigStoreDaoImpl.class);
    public static final String CONTEXT_CONFIG = "CM_CONFIG";
    public static final String CONTEXT_SCHEMA = "CM_SCHEMA";
    private final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JsonOrgModule());
    private final JsonStore jsonStore;

    public JsonConfigStoreDaoImpl(JsonStore jsonStore) {
        this.jsonStore = Objects.requireNonNull(jsonStore);
    }

    public void register(ConfigDefinition configDefinition) {
        this.putConfigDefinition(configDefinition);
    }

    public Set<String> getConfigNames() {
        return this.getIds(CONTEXT_SCHEMA);
    }

    private Set<String> getIds(String context) {
        Map allMap = this.jsonStore.enumerateContext(context);
        if (allMap == null) {
            return Collections.emptySet();
        }
        return allMap.keySet();
    }

    public Map<String, ConfigDefinition> getAllConfigDefinitions() {
        HashMap<String, ConfigDefinition> output = new HashMap<String, ConfigDefinition>();
        this.jsonStore.enumerateContext(CONTEXT_SCHEMA).forEach((key, value) -> output.put((String)key, this.deserializeConfigDefinition((String)value)));
        return output;
    }

    private ConfigDefinition deserializeConfigDefinition(String jsonStr) {
        try {
            return (ConfigDefinition)this.mapper.readValue(jsonStr, ConfigDefinition.class);
        }
        catch (JsonProcessingException e) {
            throw new SchemaConversionException(jsonStr, (Throwable)e);
        }
    }

    public Optional<ConfigDefinition> getConfigDefinition(String configName) {
        Optional jsonStr = this.jsonStore.get(configName, CONTEXT_SCHEMA);
        if (jsonStr.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.deserializeConfigDefinition((String)jsonStr.get()));
    }

    public void updateConfigDefinition(ConfigDefinition configDefinition) throws ValidationException {
        Optional<ConfigDefinition> oldDef = this.getConfigDefinition(configDefinition.getConfigName());
        if (oldDef.isEmpty()) {
            throw new SchemaNotFoundException("ConfigName not found: " + configDefinition.getConfigName());
        }
        Optional<ConfigData<JSONObject>> configData = this.getConfigs(configDefinition.getConfigName());
        configData.ifPresent(jsonObjectConfigData -> this.validateConfigData(configDefinition, (ConfigData<JSONObject>)jsonObjectConfigData));
        this.putConfigDefinition(configDefinition);
    }

    public Optional<ConfigData<JSONObject>> getConfigs(String configName) {
        Optional configDataJsonStr = this.jsonStore.get(configName, CONTEXT_CONFIG);
        if (configDataJsonStr.isEmpty()) {
            return Optional.empty();
        }
        JavaType type = this.mapper.getTypeFactory().constructParametricType(ConfigData.class, new Class[]{JSONObject.class});
        try {
            return Optional.of((ConfigData)this.mapper.readValue((String)configDataJsonStr.get(), type));
        }
        catch (JsonProcessingException e) {
            throw new ConfigConversionException((String)configDataJsonStr.get(), (Throwable)e);
        }
    }

    public void addConfigs(String configName, ConfigData<JSONObject> configData) throws ValidationException {
        Optional<ConfigData<JSONObject>> exist = this.getConfigs(configName);
        if (exist.isPresent()) {
            throw new ConfigAlreadyExistsException("Duplicate config found for service: " + configName);
        }
        this.validateConfigData(configName, configData);
        this.putConfig(configName, configData);
    }

    public void addConfig(String configName, String configId, JSONObject configObject) throws ValidationException {
        ConfigData<JSONObject> configData = this.getConfigs(configName).orElse((ConfigData<JSONObject>)new ConfigData());
        Map configs = configData.getConfigs();
        if (configs.containsKey(configId)) {
            throw new ConfigAlreadyExistsException("Duplicate config found for configId: " + configId);
        }
        this.validateConfig(configName, configObject);
        configs.put(configId, configObject);
        this.putConfig(configName, configData);
    }

    public Optional<JSONObject> getConfig(String configName, String configId) {
        return this.getConfigs(configName).flatMap(configData -> Optional.ofNullable((JSONObject)configData.getConfigs().get(configId)));
    }

    public void updateConfigs(String configName, ConfigData<JSONObject> configData) throws ValidationException {
        this.validateConfigData(configName, configData);
        this.putConfig(configName, configData);
    }

    public void deleteConfig(String configName, String configId) {
        ConfigDefinition configDefinition = this.getConfigDefinition(configName).orElseThrow(() -> new ConfigNotFoundException("ConfigDefinition not found for config=" + configName));
        ConfigData<JSONObject> configData = this.getConfigs(configName).orElseThrow(() -> new ConfigNotFoundException("Config not found for config=" + configName + ", configId=" + configId));
        if (configData.getConfigs().size() <= 1 && !configDefinition.getAllowMultiple()) {
            throw new ConfigRuntimeException("Deletion of the last config is not allowed. " + configName + ", configId " + configId, null);
        }
        if (configData.getConfigs().remove(configId) == null) {
            throw new ConfigNotFoundException("Config not found for config " + configName + ", configId " + configId);
        }
        this.putConfig(configName, configData);
    }

    public void unregister(String configName) {
        this.jsonStore.delete(configName, CONTEXT_SCHEMA);
        this.jsonStore.delete(configName, CONTEXT_CONFIG);
    }

    public Map<String, JSONObject> get(String configName) {
        Optional<ConfigData<JSONObject>> configData = this.getConfigs(configName);
        if (configData.isEmpty()) {
            return Collections.emptyMap();
        }
        return configData.get().getConfigs();
    }

    private void putConfigDefinition(ConfigDefinition configDefinition) {
        try {
            long timestamp = this.jsonStore.put(configDefinition.getConfigName(), (Object)this.mapper.writeValueAsString((Object)configDefinition), CONTEXT_SCHEMA);
            if (timestamp < 0L) {
                throw new ConfigIOException("Fail to put ConfigDefinition in JsonStore! configName: " + configDefinition.getConfigName(), null);
            }
        }
        catch (JsonProcessingException e) {
            throw new SchemaConversionException("Fail to convert Definition to String! configName: " + configDefinition.getConfigName(), (Throwable)e);
        }
    }

    private void putConfig(String configName, ConfigData<JSONObject> configData) {
        try {
            long timestamp = this.jsonStore.put(configName, (Object)this.mapper.writeValueAsString(configData), CONTEXT_CONFIG);
            if (timestamp < 0L) {
                throw new ConfigIOException("Fail to put data in JsonStore! configName: " + configName, null);
            }
        }
        catch (JsonProcessingException e) {
            throw new ConfigConversionException("Fail to convert ConfigData to String! configName: " + configName, (Throwable)e);
        }
    }

    private void validateConfigData(String configName, ConfigData<JSONObject> configData) throws ValidationException {
        this.getConfigDefinition(configName).ifPresentOrElse(def -> this.validateConfigData((ConfigDefinition)def, configData), () -> {
            LOG.error("ConfigDefinition not found! configName: " + configName);
            throw new ConfigNotFoundException("ConfigDefinition not found! configName: " + configName);
        });
    }

    private void validateConfigData(ConfigDefinition configDefinition, ConfigData<JSONObject> configData) throws ValidationException {
        Map configs = configData.getConfigs();
        if (!configDefinition.getAllowMultiple() && configs.size() > 1) {
            throw new ConfigRuntimeException(String.format("Cannot set multiple configurations for '%s'", configDefinition.getConfigName()));
        }
        configs.forEach((key, config) -> this.validateConfig(configDefinition, (JSONObject)config));
    }

    private void validateConfig(String configName, JSONObject configObject) {
        this.getConfigDefinition(configName).ifPresentOrElse(def -> this.validateConfig((ConfigDefinition)def, configObject), () -> {
            LOG.error("ConfigDefinition not found! configName: " + configName);
            throw new ConfigNotFoundException("ConfigDefinition not found! configName: " + configName);
        });
    }

    private void validateConfig(ConfigDefinition configDefinition, JSONObject configObject) {
        configDefinition.validate(configObject.toString());
    }
}

