/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.admin.notifications;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.config.NotificationFactory;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.config.notifications.Notification;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class EventNoticesController
extends AbstractController {
    @Autowired
    private EventConfDao m_eventConfDao;
    @Autowired
    private NotificationFactory m_notificationFactory;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.m_eventConfDao.reload();
        return new ModelAndView("/admin/notification/noticeWizard/eventNotices", "notifications", this.getNotifications());
    }

    private List<EventNotification> getNotifications() throws IOException {
        LinkedList notifications = Lists.newLinkedList();
        Map noticeMap = this.m_notificationFactory.getNotifications();
        for (String name : noticeMap.keySet()) {
            notifications.add(new EventNotification(name, (Notification)noticeMap.get(name)));
        }
        Collections.sort(notifications);
        return notifications;
    }

    public void setEventConfDao(EventConfDao eventConfDao) {
        this.m_eventConfDao = eventConfDao;
    }

    public void setNotificationFactory(NotificationFactory notificationFactory) {
        this.m_notificationFactory = notificationFactory;
    }

    public class EventNotification
    implements Comparable<EventNotification> {
        final String m_name;
        final String m_uei;
        final Notification m_notification;

        public EventNotification(String name, Notification notification) {
            this.m_name = name;
            this.m_notification = notification;
            this.m_uei = notification.getUei();
        }

        public String getName() {
            return this.m_name;
        }

        public boolean getIsOn() {
            return "on".equalsIgnoreCase(this.m_notification.getStatus());
        }

        public String getUei() {
            return this.m_uei;
        }

        public String getEventLabel() {
            return EventNoticesController.this.m_eventConfDao.getEventLabel(this.m_uei);
        }

        public String getDisplayUei() {
            if (this.m_uei != null && this.m_uei.startsWith("~")) {
                return "REGEX: " + this.m_uei.substring(1);
            }
            return this.m_uei;
        }

        @Override
        public int compareTo(EventNotification other) {
            return this.m_name.compareTo(other.m_name);
        }
    }
}

