/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.account.selfService;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.netmgt.config.UserFactory;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.config.users.Password;
import org.opennms.netmgt.config.users.User;

public abstract class AbstractBasePasswordChangeActionServlet
extends HttpServlet {
    public static final String PASSWORD_REGEX = "((?=.*\\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[!@#$%&.*+-]).{12,128})";
    public static final String SAME_CHARACTER_REGEX = "(.)\\1{5}";

    protected void initUserFactory(String servletName) throws ServletException {
        try {
            UserFactory.init();
        }
        catch (Throwable e) {
            throw new ServletException(servletName + ": Error initializing user factory." + String.valueOf(e));
        }
    }

    protected void readonlyUserCheck(HttpServletRequest request, User user) throws ServletException {
        if (!request.isUserInRole("ROLE_ADMIN") && user.getRoles().contains("ROLE_READONLY")) {
            throw new ServletException("User " + user.getUserId() + " is read-only");
        }
    }

    protected boolean validatePassword(String password) {
        boolean isPasswordComplexityValid = Pattern.compile(PASSWORD_REGEX).matcher(password).matches();
        boolean isPasswordWithSameCharacters = Pattern.compile(SAME_CHARACTER_REGEX).matcher(password).matches();
        return isPasswordComplexityValid && !isPasswordWithSameCharacters;
    }

    protected void verifyAndChangePassword(UserManager userFactory, HttpSession userSession, User user, HttpServletRequest request, HttpServletResponse response, String currentPassword, String newPassword, String redoUrl, String nextUrl, boolean redirectAfterSuccess) throws IOException, ServletException {
        if (!userFactory.comparePasswords(user.getUserId(), currentPassword)) {
            RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(redoUrl);
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        } else if (this.validatePassword(newPassword)) {
            Password pass = new Password();
            pass.setEncryptedPassword(userFactory.encryptedPassword(newPassword, true));
            pass.setSalt(Boolean.valueOf(true));
            user.setPassword(pass);
            userSession.setAttribute("user.newPassword.jsp", (Object)user);
            try {
                userFactory.saveUser(user.getUserId(), user);
            }
            catch (Throwable e) {
                throw new ServletException("Error saving user " + user.getUserId(), e);
            }
            if (redirectAfterSuccess) {
                response.sendRedirect(nextUrl);
            } else {
                RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(nextUrl);
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
        } else {
            throw new ServletException("Error saving user " + user.getUserId() + ":::Password complexity is not correct! Please use at least 12 characters, consisting of 1 special character, 1 upper case letter, 1 lower case letter and 1 number. Identical strings with 6 or more characters in a row are also not allowed.");
        }
    }
}

