/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.health.immutables;

import java.util.Objects;
import org.opennms.integration.api.v1.health.Response;
import org.opennms.integration.api.v1.health.Status;

public final class ImmutableResponse
implements Response {
    private final Status status;
    private final String message;

    private ImmutableResponse(Status status, String message) {
        this.status = status;
        this.message = message;
    }

    public static ImmutableResponse newInstance(Status status) {
        return new ImmutableResponse(status, null);
    }

    public static ImmutableResponse newInstance(Exception ex) {
        return new ImmutableResponse(Status.Failure, Objects.requireNonNull(ex).getMessage());
    }

    public static ImmutableResponse newInstance(Status status, String message) {
        return new ImmutableResponse(Objects.requireNonNull(status), message);
    }

    public static Response immutableCopy(Response response) {
        if (response == null || response instanceof ImmutableResponse) {
            return response;
        }
        return ImmutableResponse.newInstance(response.getStatus(), response.getMessage());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(Response response) {
        return new Builder(response);
    }

    public String getMessage() {
        return this.message;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableResponse that = (ImmutableResponse)o;
        return this.status == that.status && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.message);
    }

    public String toString() {
        return "ImmutableResponse{status=" + this.status + ", message='" + this.message + "'}";
    }

    public static final class Builder {
        private Status status;
        private String message;

        private Builder() {
        }

        private Builder(Response response) {
            this.status = response.getStatus();
            this.message = response.getMessage();
        }

        public Builder setStatus(Status status) {
            this.status = status;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public ImmutableResponse build() {
            return ImmutableResponse.newInstance(this.status, this.message);
        }
    }
}

