/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.compiler.rule.builder.EvaluatorDefinition;
import org.drools.core.base.ValueType;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.rule.accessor.Evaluator;
import org.drools.core.time.Interval;
import org.drools.core.util.TimeIntervalParser;
import org.drools.drl.parser.impl.Operator;
import org.drools.mvel.evaluators.PointInTimeEvaluator;

public class BeforeEvaluatorDefinition
implements EvaluatorDefinition {
    public static final String beforeOp = Operator.BuiltInOperator.BEFORE.getSymbol();
    public static final Operator BEFORE = Operator.determineOperator((String)beforeOp, (boolean)false);
    public static final Operator NOT_BEFORE = Operator.determineOperator((String)beforeOp, (boolean)true);
    private static final String[] SUPPORTED_IDS = new String[]{beforeOp};
    private Map<String, BeforeEvaluator> cache = Collections.emptyMap();

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = (Map)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cache);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.HANDLE, EvaluatorDefinition.Target.HANDLE);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        String key;
        BeforeEvaluator eval;
        if (this.cache == Collections.EMPTY_MAP) {
            this.cache = new HashMap<String, BeforeEvaluator>();
        }
        if ((eval = this.cache.get(key = left + ":" + right + ":" + isNegated + ":" + parameterText)) == null) {
            long[] params = TimeIntervalParser.parse((String)parameterText);
            eval = new BeforeEvaluator(type, isNegated, params, parameterText, left == EvaluatorDefinition.Target.FACT, right == EvaluatorDefinition.Target.FACT);
            this.cache.put(key, eval);
        }
        return eval;
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public boolean isNegatable() {
        return true;
    }

    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.BOTH;
    }

    public boolean supportsType(ValueType type) {
        return true;
    }

    public static class BeforeEvaluator
    extends PointInTimeEvaluator {
        private static final long serialVersionUID = 510L;

        public BeforeEvaluator() {
        }

        public BeforeEvaluator(ValueType type, boolean isNegated, long[] parameters, String paramText, boolean unwrapLeft, boolean unwrapRight) {
            super(type, isNegated ? NOT_BEFORE : BEFORE, parameters, paramText, unwrapLeft, unwrapRight);
        }

        @Override
        public Interval getInterval() {
            long end;
            long init = this.finalRange == Long.MAX_VALUE ? Long.MIN_VALUE : -this.finalRange;
            long l = end = this.initRange == Long.MIN_VALUE ? Long.MAX_VALUE : -this.initRange;
            if (this.getOperator().isNegated()) {
                if (init == Long.MIN_VALUE && end != Long.MAX_VALUE) {
                    init = this.finalRange + 1L;
                    end = Long.MAX_VALUE;
                } else if (init != Long.MIN_VALUE && end == Long.MAX_VALUE) {
                    init = Long.MIN_VALUE;
                    end = this.initRange - 1L;
                } else if (init == Long.MIN_VALUE) {
                    init = 0L;
                    end = -1L;
                } else {
                    init = Long.MIN_VALUE;
                    end = Long.MAX_VALUE;
                }
            }
            return new Interval(init, end);
        }

        @Override
        protected boolean evaluate(long rightTS, long leftTS) {
            long dist = leftTS - rightTS;
            return this.getOperator().isNegated() ^ (dist >= this.initRange && dist <= this.finalRange);
        }

        @Override
        protected long getLeftTimestamp(InternalFactHandle handle) {
            return ((EventFactHandle)handle).getStartTimestamp();
        }

        @Override
        protected long getRightTimestamp(InternalFactHandle handle) {
            return ((EventFactHandle)handle).getEndTimestamp();
        }
    }
}

