/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.api.generic;

import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Objects;
import org.opennms.netmgt.graph.api.Edge;
import org.opennms.netmgt.graph.api.VertexRef;
import org.opennms.netmgt.graph.api.generic.GenericElement;
import org.opennms.netmgt.graph.api.generic.MapBuilder;

public final class GenericEdge
extends GenericElement
implements Edge {
    private final VertexRef source;
    private final VertexRef target;

    private GenericEdge(VertexRef source, VertexRef target, Map<String, Object> properties) {
        super(new MapBuilder<String, Object>().withProperties(properties).withProperty("id", properties.getOrDefault("id", source.getNamespace() + ":" + source.getId() + "->" + target.getNamespace() + ":" + target.getId())).build());
        this.source = Objects.requireNonNull(source);
        this.target = Objects.requireNonNull(target);
        if (!source.getNamespace().equals(this.getNamespace()) && !target.getNamespace().equals(this.getNamespace())) {
            throw new IllegalArgumentException(String.format("Neither the namespace of the source VertexRef(namespace=%s) nor the target VertexRef(%s) matches our namespace=%s", source.getNamespace(), target.getNamespace(), this.getNamespace()));
        }
    }

    @Override
    public VertexRef getSource() {
        return this.source;
    }

    @Override
    public VertexRef getTarget() {
        return this.target;
    }

    @Override
    public GenericEdge asGenericEdge() {
        return this;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.source).add("target", (Object)this.target).add("properties", (Object)this.properties).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GenericEdge that = (GenericEdge)o;
        return Objects.equals(this.source, that.source) && Objects.equals(this.target, that.target);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.source, this.target);
    }

    public static GenericEdgeBuilder builder() {
        return new GenericEdgeBuilder();
    }

    public static final class GenericEdgeBuilder
    extends GenericElement.GenericElementBuilder<GenericEdgeBuilder> {
        private VertexRef source;
        private VertexRef target;

        private GenericEdgeBuilder() {
        }

        public GenericEdgeBuilder edge(GenericEdge edge) {
            Objects.requireNonNull(edge);
            this.properties(edge.getProperties());
            this.source(edge.getSource());
            this.target(edge.getTarget());
            return this;
        }

        public GenericEdgeBuilder source(String namespace, String id) {
            this.source(new VertexRef(namespace, id));
            return this;
        }

        public GenericEdgeBuilder source(VertexRef source) {
            Objects.requireNonNull(source);
            this.source = source;
            return this;
        }

        public GenericEdgeBuilder target(String namespace, String id) {
            this.target(new VertexRef(namespace, id));
            return this;
        }

        public GenericEdgeBuilder target(VertexRef target) {
            Objects.requireNonNull(target);
            this.target = target;
            return this;
        }

        public GenericEdge build() {
            return new GenericEdge(this.source, this.target, this.properties);
        }
    }
}

