/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.schema;

import com.atlassian.oai.validator.report.MessageResolver;
import com.atlassian.oai.validator.report.ValidationReport;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

class ProcessingMessageConverter {
    private final MessageResolver messages;

    public ProcessingMessageConverter(@Nonnull MessageResolver messages) {
        this.messages = Objects.requireNonNull(messages);
    }

    ValidationReport toValidationReport(ProcessingMessage pm, String keywordOverride, String keyPrefix) {
        return ValidationReport.singleton(this.toValidationReportMessage(pm.asJson(), keywordOverride, keyPrefix));
    }

    ValidationReport.Message toValidationReportMessage(JsonNode pm, String keywordOverride, String keyPrefix) {
        String validationKeyword = this.getValidationKeyword(pm, keywordOverride);
        String instancePointer = this.getInstancePointer(pm);
        String schemaPointer = this.getSchemaPointer(pm);
        ArrayList subReports = new ArrayList();
        if (pm.has("reports")) {
            JsonNode reports = pm.get("reports");
            reports.fields().forEachRemaining(field -> ((JsonNode)field.getValue()).elements().forEachRemaining(report -> subReports.add((String)field.getKey() + ": " + StringUtils.capitalize((String)report.get("message").textValue()))));
        }
        String message = this.buildMessage(pm, instancePointer);
        ValidationReport.Message validationReportMessage = this.messages.create("validation." + keyPrefix + ".schema." + validationKeyword, message, subReports.toArray(new String[0])).withAdditionalContext(ValidationReport.MessageContext.create().withPointers(instancePointer.isEmpty() ? "/" : instancePointer, schemaPointer).build());
        return this.withNestedMessages(pm, keywordOverride, keyPrefix, validationReportMessage);
    }

    private String buildMessage(JsonNode pm, String pointer) {
        return (pointer.isEmpty() ? "" : "[Path '" + pointer + "'] ") + StringUtils.capitalize((String)pm.get("message").textValue());
    }

    private String getInstancePointer(JsonNode pm) {
        return pm.has("instance") ? pm.get("instance").get("pointer").textValue() : "";
    }

    private String getSchemaPointer(JsonNode pm) {
        if (!pm.has("schema")) {
            return "/";
        }
        JsonNode schemaNode = pm.get("schema");
        if (schemaNode.isTextual()) {
            return schemaNode.textValue();
        }
        if (schemaNode.isObject()) {
            return schemaNode.has("pointer") ? schemaNode.get("pointer").textValue() : "";
        }
        return "/";
    }

    private String getValidationKeyword(JsonNode pm, String keywordOverride) {
        String suffix;
        String string = suffix = pm.has("attribute") ? "." + pm.get("attribute").textValue() : "";
        if (keywordOverride != null) {
            return keywordOverride + suffix;
        }
        return pm.get("keyword").textValue() + suffix;
    }

    private ValidationReport.Message withNestedMessages(JsonNode pm, String keywordOverride, String keyPrefix, ValidationReport.Message validationReportMessage) {
        if (!pm.has("reports")) {
            return validationReportMessage;
        }
        ArrayList<ValidationReport.Message> nestedMessages = new ArrayList<ValidationReport.Message>();
        JsonNode reports = pm.get("reports");
        if (reports.isArray()) {
            reports.iterator().forEachRemaining(report -> nestedMessages.add(this.toValidationReportMessage((JsonNode)report, keywordOverride, keyPrefix)));
        } else if (reports.isObject()) {
            reports.fields().forEachRemaining(field -> ((JsonNode)field.getValue()).iterator().forEachRemaining(report -> nestedMessages.add(this.toValidationReportMessage((JsonNode)report, keywordOverride, keyPrefix))));
        }
        return validationReportMessage.withNestedMessages(nestedMessages);
    }
}

