/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.interaction.request;

import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

class ArraySeparator {
    private final String paramName;
    private final String prefix;
    @Nullable
    private final String separator;
    private final boolean isMultiValueParam;
    private final boolean expectEmbeddedParamName;
    private final boolean expectLeadingParamName;

    static ArraySeparator from(Parameter parameter) {
        Builder builder = new Builder().withParamName(parameter.getName()).withSeparator(",");
        if (parameter.getStyle() == null) {
            return builder.build();
        }
        Parameter.StyleEnum style = ArraySeparator.getStyleFromParam(parameter);
        boolean explode = ArraySeparator.getExplodeFromParam(style, parameter);
        switch (style) {
            case SIMPLE: {
                builder.withSeparator(",");
                break;
            }
            case MATRIX: {
                builder.withPrefix(";");
                if (explode) {
                    builder.withSeparator(";").withEmbeddedParamName();
                    break;
                }
                builder.withSeparator(",").withLeadingParamName();
                break;
            }
            case LABEL: {
                builder.withSeparator("\\.").withPrefix(".");
                break;
            }
            case FORM: {
                if (!explode) break;
                builder.withSeparator(null).asMultiValueParam();
                break;
            }
            case SPACEDELIMITED: {
                builder.withSeparator(" ");
                break;
            }
            case PIPEDELIMITED: {
                builder.withSeparator("\\|");
                break;
            }
        }
        return builder.build();
    }

    private static boolean getExplodeFromParam(Parameter.StyleEnum style, Parameter parameter) {
        if (parameter.getExplode() != null) {
            return parameter.getExplode();
        }
        return style == Parameter.StyleEnum.FORM;
    }

    private static Parameter.StyleEnum getStyleFromParam(Parameter parameter) {
        if (parameter.getStyle() != null) {
            return parameter.getStyle();
        }
        String in = parameter.getIn();
        if ("query".equalsIgnoreCase(in) || "cookie".equalsIgnoreCase(in)) {
            return Parameter.StyleEnum.FORM;
        }
        return Parameter.StyleEnum.SIMPLE;
    }

    private ArraySeparator(String paramName, @Nullable String separator, String prefix, boolean isMultiValueParam, boolean expectEmbeddedParamName, boolean expectLeadingParamName) {
        this.paramName = paramName;
        this.separator = separator;
        this.prefix = prefix;
        this.isMultiValueParam = isMultiValueParam;
        this.expectEmbeddedParamName = expectEmbeddedParamName;
        this.expectLeadingParamName = expectLeadingParamName;
    }

    boolean isMultiValueParam() {
        return this.isMultiValueParam;
    }

    Collection<String> split(String value) {
        if (this.separator == null) {
            return Collections.singletonList(value);
        }
        if (value.isEmpty()) {
            return Collections.emptyList();
        }
        String valueToSplit = StringUtils.removeStart((String)value, (String)this.prefix);
        if (this.expectLeadingParamName) {
            valueToSplit = StringUtils.removeStart((String)valueToSplit, (String)(this.paramName + "="));
        }
        List<String> result = Arrays.asList(valueToSplit.split(this.separator));
        if (this.expectEmbeddedParamName) {
            result = result.stream().map(v -> StringUtils.removeStart((String)v, (String)(this.paramName + "="))).collect(Collectors.toList());
        }
        return result;
    }

    private static final class Builder {
        private String paramName;
        private String separator;
        private String prefix = "";
        private boolean isMultiValueParam = false;
        private boolean expectEmbeddedParamName = false;
        private boolean expectLeadingParamName = false;

        private Builder() {
        }

        private Builder withParamName(String paramName) {
            this.paramName = paramName;
            return this;
        }

        private Builder withSeparator(String separator) {
            this.separator = separator;
            return this;
        }

        private Builder asMultiValueParam() {
            this.isMultiValueParam = true;
            return this;
        }

        private Builder withPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        private Builder withEmbeddedParamName() {
            this.expectEmbeddedParamName = true;
            return this;
        }

        private Builder withLeadingParamName() {
            this.expectLeadingParamName = true;
            return this;
        }

        private ArraySeparator build() {
            return new ArraySeparator(this.paramName, this.separator, this.prefix, this.isMultiValueParam, this.expectEmbeddedParamName, this.expectLeadingParamName);
        }
    }
}

