/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.endpoints.grafana.client;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Properties;

public class GrafanaServerConfiguration {
    public static int DEFAULT_CONNECT_TIMEOUT_IN_SECONDS = 30;
    public static int DEFAULT_READ_TIMEOUT_IN_SECONDS = 30;
    private final String url;
    private final String apiKey;
    private final int connectTimeoutSeconds;
    private final int readTimeoutSeconds;

    public static GrafanaServerConfiguration fromEnv() {
        GrafanaServerConfiguration grafanaServerConfiguration;
        File configFile = Paths.get(System.getProperty("user.home"), ".grafana", "server.properties").toFile();
        FileInputStream input = new FileInputStream(configFile);
        try {
            Properties prop = new Properties();
            prop.load(input);
            String url = prop.getProperty("url");
            String apiKey = prop.getProperty("apiKey");
            int connectTimeout = Integer.parseInt(prop.getProperty("connectTimeout", Integer.toString(DEFAULT_CONNECT_TIMEOUT_IN_SECONDS)));
            int readTimeout = Integer.parseInt(prop.getProperty("readTimeout", Integer.toString(DEFAULT_READ_TIMEOUT_IN_SECONDS)));
            grafanaServerConfiguration = new GrafanaServerConfiguration(url, apiKey, connectTimeout, readTimeout);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ((InputStream)input).close();
        return grafanaServerConfiguration;
    }

    public GrafanaServerConfiguration(String url, String apiKey, Integer connectTimeoutSeconds, Integer readTimeoutSeconds) {
        this.url = Objects.requireNonNull(url);
        this.apiKey = Objects.requireNonNull(apiKey);
        this.connectTimeoutSeconds = connectTimeoutSeconds == null ? DEFAULT_CONNECT_TIMEOUT_IN_SECONDS : connectTimeoutSeconds;
        this.readTimeoutSeconds = readTimeoutSeconds == null ? DEFAULT_READ_TIMEOUT_IN_SECONDS : readTimeoutSeconds;
        Preconditions.checkArgument(this.connectTimeoutSeconds >= 0, "connectTimeoutSeconds must be >= 0");
        Preconditions.checkArgument(this.readTimeoutSeconds >= 0, "readTimeoutSeconds must be >= 0");
    }

    public String getUrl() {
        return this.url;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public int getConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds;
    }

    public int getReadTimeoutSeconds() {
        return this.readTimeoutSeconds;
    }

    public String toString() {
        return "GrafanaServerConfiguration{url='" + this.url + "', apiKey='" + this.apiKey + "', connectTimeoutSeconds=" + this.connectTimeoutSeconds + ", readTimeoutSeconds=" + this.readTimeoutSeconds + "}";
    }
}

