/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import org.opennms.core.mate.api.EntityScopeProvider;
import org.opennms.netmgt.provision.service.ImportJob;
import org.opennms.netmgt.provision.service.MonitorHolder;
import org.opennms.netmgt.provision.service.Provisioner;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;
import org.springframework.beans.factory.annotation.Autowired;

public class ImportJobFactory
implements JobFactory {
    private Provisioner provisioner;
    @Autowired
    private MonitorHolder monitorHolder;
    @Autowired
    private EntityScopeProvider entityScopeProvider;

    public Job newJob(TriggerFiredBundle bundle, Scheduler scheduler) throws SchedulerException {
        JobDetail jobDetail = bundle.getJobDetail();
        Class<ImportJob> jobClass = this.getJobClass(jobDetail);
        ImportJob job = null;
        try {
            job = jobClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            job.setProvisioner(this.getProvisioner());
            job.setMonitor(this.monitorHolder.createMonitor(jobDetail.getKey().getName(), job));
            job.setEntityScopeProvider(this.entityScopeProvider);
            return job;
        }
        catch (Exception e) {
            throw new SchedulerException("failed to create job class: " + jobDetail.getJobClass().getName() + "; " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private Class<ImportJob> getJobClass(JobDetail jobDetail) {
        return jobDetail.getJobClass();
    }

    public void setProvisioner(Provisioner provisioner) {
        this.provisioner = provisioner;
    }

    private Provisioner getProvisioner() {
        return this.provisioner;
    }
}

