/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.persistence.api;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.Size;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceEdgeEntity;
import org.opennms.netmgt.bsm.persistence.api.EdgeEntityVisitor;
import org.opennms.netmgt.dao.util.ReductionKeyHelper;
import org.opennms.netmgt.model.OnmsMonitoredService;

@Entity
@Table(name="bsm_service_ifservices")
@PrimaryKeyJoinColumn(name="id")
@DiscriminatorValue(value="ipservices")
public class IPServiceEdgeEntity
extends BusinessServiceEdgeEntity {
    private OnmsMonitoredService m_ipService;
    private String m_friendlyName;

    @ManyToOne(optional=false)
    @JoinColumn(name="ifserviceid", nullable=false)
    public OnmsMonitoredService getIpService() {
        return this.m_ipService;
    }

    public void setIpService(OnmsMonitoredService ipService) {
        this.m_ipService = ipService;
    }

    @Column(name="friendlyname", nullable=true)
    @Size(min=0, max=30)
    public String getFriendlyName() {
        return this.m_friendlyName;
    }

    public void setFriendlyName(String friendlyName) {
        this.m_friendlyName = friendlyName;
    }

    @Override
    @Transient
    public Set<String> getReductionKeys() {
        return ReductionKeyHelper.getReductionKeys((OnmsMonitoredService)this.m_ipService);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("super", (Object)super.toString()).add("ipService", (Object)this.m_ipService).toString();
    }

    @Override
    public boolean equalsDefinition(BusinessServiceEdgeEntity other) {
        boolean equalsSuper = super.equalsDefinition(other);
        if (equalsSuper) {
            return Objects.equals(this.m_ipService, ((IPServiceEdgeEntity)other).m_ipService) && Objects.equals(this.m_friendlyName, ((IPServiceEdgeEntity)other).m_friendlyName);
        }
        return false;
    }

    @Override
    public <T> T accept(EdgeEntityVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

