/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.criteria.restrictions;

import org.opennms.core.criteria.restrictions.AttributeRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.RestrictionVisitor;

public class SqlRestriction
extends AttributeRestriction {
    final Object[] parameters;
    final Type[] types;

    public SqlRestriction(String attribute) {
        this(attribute, new Object[0], new Type[0]);
    }

    public SqlRestriction(String attribute, Object parameter, Type type) {
        this(attribute, new Object[]{parameter}, new Type[]{type});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SqlRestriction(String attribute, Object[] parameters, Type[] types) {
        super(Restriction.RestrictionType.SQL, attribute);
        if (parameters == null) {
            if (types != null) throw new IllegalArgumentException("Cannot have non-null types with null parameters");
            this.parameters = new Object[0];
            this.types = new Type[0];
            return;
        } else {
            if (types == null) {
                throw new IllegalArgumentException("Cannot have null types with non-null parameters");
            }
            if (parameters.length != types.length) throw new IllegalArgumentException("Parameter and type lists are different lengths");
            this.parameters = parameters;
            this.types = types;
        }
    }

    @Override
    public void visit(RestrictionVisitor visitor) {
        visitor.visitSql(this);
    }

    @Override
    public String toString() {
        return "SqlRestriction [attribute=" + this.getAttribute() + "]";
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public Type[] getTypes() {
        return this.types;
    }

    public static enum Type {
        FLOAT,
        INTEGER,
        LONG,
        STRING,
        TIMESTAMP;

    }
}

