/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.application.browsers;

import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;

public class ApplicationOutage {
    final OnmsOutage delegate;

    ApplicationOutage(OnmsOutage delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public int getId() {
        return this.delegate.getId();
    }

    public String getNodeLabel() {
        return this.delegate.getNodeLabel();
    }

    public String getForeignSource() {
        return this.delegate.getForeignSource();
    }

    public String getForeignId() {
        return this.delegate.getForeignId();
    }

    public String getIpAddress() {
        return Optional.ofNullable(this.delegate.getMonitoredService()).map(OnmsMonitoredService::getIpInterface).map(OnmsIpInterface::getIpAddress).map(InetAddressUtils::toIpAddrString).orElse("null");
    }

    public String getServiceName() {
        return Optional.ofNullable(this.delegate.getServiceType()).map(OnmsServiceType::getName).orElse("null");
    }

    public Date getIfLostService() {
        return this.delegate.getIfLostService();
    }

    public String getPerspective() {
        return Optional.ofNullable(this.delegate.getPerspective()).map(OnmsMonitoringLocation::getLocationName).orElse("null");
    }
}

