/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.Date;
import org.asteriskjava.live.ManagerCommunicationException;
import org.asteriskjava.live.MeetMeUser;
import org.asteriskjava.live.MeetMeUserState;
import org.asteriskjava.live.internal.AbstractLiveObject;
import org.asteriskjava.live.internal.AsteriskChannelImpl;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.live.internal.MeetMeRoomImpl;
import org.asteriskjava.manager.action.CommandAction;

class MeetMeUserImpl
extends AbstractLiveObject
implements MeetMeUser {
    private static final String COMMAND_PREFIX = "meetme";
    private static final String MUTE_COMMAND = "mute";
    private static final String UNMUTE_COMMAND = "unmute";
    private static final String KICK_COMMAND = "kick";
    private final MeetMeRoomImpl room;
    private final Integer userNumber;
    private final AsteriskChannelImpl channel;
    private final Date dateJoined;
    private Date dateLeft;
    private MeetMeUserState state;
    private boolean talking;
    private boolean muted;

    MeetMeUserImpl(AsteriskServerImpl server, MeetMeRoomImpl room, Integer userNumber, AsteriskChannelImpl channel, Date dateJoined) {
        super(server);
        this.room = room;
        this.userNumber = userNumber;
        this.channel = channel;
        this.dateJoined = dateJoined;
        this.state = MeetMeUserState.JOINED;
    }

    @Override
    public MeetMeRoomImpl getRoom() {
        return this.room;
    }

    @Override
    public Integer getUserNumber() {
        return this.userNumber;
    }

    @Override
    public AsteriskChannelImpl getChannel() {
        return this.channel;
    }

    @Override
    public Date getDateJoined() {
        return this.dateJoined;
    }

    @Override
    public Date getDateLeft() {
        return this.dateLeft;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void left(Date dateLeft) {
        MeetMeUserState oldState;
        MeetMeUserImpl meetMeUserImpl = this;
        synchronized (meetMeUserImpl) {
            oldState = this.state;
            this.dateLeft = dateLeft;
            this.state = MeetMeUserState.LEFT;
        }
        this.firePropertyChange("state", (Object)oldState, (Object)this.state);
    }

    @Override
    public MeetMeUserState getState() {
        return this.state;
    }

    @Override
    public boolean isTalking() {
        return this.talking;
    }

    void setTalking(boolean talking) {
        boolean oldTalking = this.talking;
        this.talking = talking;
        this.firePropertyChange("talking", oldTalking, talking);
    }

    @Override
    public boolean isMuted() {
        return this.muted;
    }

    void setMuted(boolean muted) {
        boolean oldMuted = this.muted;
        this.muted = muted;
        this.firePropertyChange("muted", oldMuted, muted);
    }

    @Override
    public void kick() throws ManagerCommunicationException {
        this.sendMeetMeUserCommand(KICK_COMMAND);
    }

    @Override
    public void mute() throws ManagerCommunicationException {
        this.sendMeetMeUserCommand(MUTE_COMMAND);
    }

    @Override
    public void unmute() throws ManagerCommunicationException {
        this.sendMeetMeUserCommand(UNMUTE_COMMAND);
    }

    private void sendMeetMeUserCommand(String command) throws ManagerCommunicationException {
        StringBuffer sb = new StringBuffer();
        sb.append(COMMAND_PREFIX);
        sb.append(" ");
        sb.append(command);
        sb.append(" ");
        sb.append(this.room.getRoomNumber());
        sb.append(" ");
        sb.append(this.userNumber);
        this.server.sendAction(new CommandAction(sb.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int systemHashcode;
        StringBuffer sb = new StringBuffer("MeetMeUser[");
        AbstractLiveObject abstractLiveObject = this;
        synchronized (abstractLiveObject) {
            sb.append("dateJoined='").append(this.getDateJoined()).append("',");
            sb.append("dateLeft='").append(this.getDateLeft()).append("',");
            sb.append("talking=").append(this.isTalking()).append(",");
            sb.append("muted=").append(this.isMuted()).append(",");
            sb.append("room=").append(this.room).append(",");
            systemHashcode = System.identityHashCode(this);
        }
        sb.append("channel=AsteriskChannel[");
        abstractLiveObject = this.channel;
        synchronized (abstractLiveObject) {
            sb.append("id='").append(this.channel.getId()).append("',");
            sb.append("name='").append(this.channel.getName()).append("'],");
        }
        sb.append("systemHashcode=").append(systemHashcode);
        sb.append("]");
        return sb.toString();
    }
}

