/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.framer;

import io.pkts.Clock;
import java.util.concurrent.atomic.AtomicLong;

public final class FramerManager {
    private static final FramerManager instance = new FramerManager();
    private final PcapClock clock = new PcapClock();

    public static final FramerManager getInstance() {
        return instance;
    }

    private FramerManager() {
    }

    public void tick(long time) {
        this.clock.tick(time);
    }

    private static class PcapClock
    implements Clock {
        private final AtomicLong currentTime = new AtomicLong();

        @Override
        public long currentTimeMillis() {
            return this.currentTime.get();
        }

        public void tick(long time) {
            this.currentTime.set(time);
        }
    }
}

