/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.invoker.junit.internal;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.ops4j.pax.exam.ProbeInvoker;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.WrappedTestContainerException;
import org.ops4j.pax.exam.invoker.junit.internal.ContainerTestRunnerClassRequest;
import org.ops4j.pax.exam.util.Injector;
import org.osgi.framework.BundleContext;

public class JUnitProbeInvoker
implements ProbeInvoker {
    private BundleContext ctx;
    private String clazz;
    private String method;
    private Injector injector;
    private Class<?> testClass;

    public JUnitProbeInvoker(String encodedInstruction, BundleContext bundleContext, Injector injector) {
        String[] parts = encodedInstruction.split(";");
        this.clazz = parts[0];
        this.method = parts[1];
        this.ctx = bundleContext;
        this.injector = injector;
        try {
            this.testClass = this.ctx.getBundle().loadClass(this.clazz);
        }
        catch (ClassNotFoundException e) {
            throw new TestContainerException((Throwable)e);
        }
    }

    public void call(Object ... args) {
        if (!this.findAndInvoke(args)) {
            throw new TestContainerException(" Test " + this.method + " not found in test class " + this.testClass.getName());
        }
    }

    private boolean findAndInvoke(Object ... args) {
        Integer index = null;
        try {
            if (args.length > 0) {
                if (!(args[0] instanceof Integer)) {
                    throw new TestContainerException("Integer argument expected");
                }
                index = (Integer)args[0];
            }
            for (Method m : this.testClass.getMethods()) {
                if (!m.getName().equals(this.method)) continue;
                this.invokeViaJUnit(m, index);
                return true;
            }
        }
        catch (NoClassDefFoundError e) {
            throw new TestContainerException((Throwable)e);
        }
        return false;
    }

    private void invokeViaJUnit(Method testMethod, Integer index) {
        JUnitCore junit = new JUnitCore();
        ContainerTestRunnerClassRequest classRequest = new ContainerTestRunnerClassRequest(this.testClass, this.injector, index);
        Description methodDescription = Description.createTestDescription(this.testClass, (String)this.method);
        Request request = classRequest.filterWith(methodDescription);
        Result result = junit.run(request);
        List failures = result.getFailures();
        if (!failures.isEmpty()) {
            throw this.createTestContainerException(failures.toString(), ((Failure)failures.get(0)).getException());
        }
    }

    private TestContainerException createTestContainerException(String message, Throwable ex) {
        return this.isSerializable(ex) ? new TestContainerException(message, ex) : new WrappedTestContainerException(message, ex);
    }

    private boolean isSerializable(Throwable ex) {
        try {
            new ObjectOutputStream(new ByteArrayOutputStream()).writeObject(ex);
            return true;
        }
        catch (Throwable ex2) {
            return false;
        }
    }
}

