/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.opennmsDataSources;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.mate.api.EnvironmentScope;
import org.opennms.core.mate.api.FallbackScope;
import org.opennms.core.mate.api.Interpolator;
import org.opennms.core.mate.api.Scope;
import org.opennms.core.mate.api.SecureCredentialsVaultScope;
import org.opennms.features.scv.api.SecureCredentialsVault;
import org.opennms.features.scv.jceks.JCEKSSecureCredentialsVault;

@XmlRootElement(name="connection-pool")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ConnectionPool
implements Serializable {
    private static final long serialVersionUID = -5071908810877550391L;
    @XmlAttribute(name="factory")
    private String factory;
    @XmlAttribute(name="idleTimeout")
    private String rawIdleTimeout;
    @XmlAttribute(name="loginTimeout")
    private String rawLoginTimeout;
    @XmlAttribute(name="minPool")
    private String rawMinPool;
    @XmlAttribute(name="maxPool")
    private String rawMaxPool;
    @XmlAttribute(name="maxSize")
    private String rawMaxSize;

    public ConnectionPool() {
        this.setFactory("org.opennms.core.db.HikariCPConnectionFactory");
    }

    public void deleteIdleTimeout() {
        this.rawIdleTimeout = null;
    }

    public void deleteLoginTimeout() {
        this.rawLoginTimeout = null;
    }

    public void deleteMaxPool() {
        this.rawMaxPool = null;
    }

    public void deleteMaxSize() {
        this.rawMaxSize = null;
    }

    public void deleteMinPool() {
        this.rawMinPool = null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ConnectionPool) {
            ConnectionPool temp = (ConnectionPool)obj;
            boolean equals = Objects.equals(temp.factory, this.factory) && Objects.equals(temp.rawIdleTimeout, this.rawIdleTimeout) && Objects.equals(temp.rawLoginTimeout, this.rawLoginTimeout) && Objects.equals(temp.rawMinPool, this.rawMinPool) && Objects.equals(temp.rawMaxPool, this.rawMaxPool) && Objects.equals(temp.rawMaxSize, this.rawMaxSize);
            return equals;
        }
        return false;
    }

    private String interpolateAttribute(String value) {
        return this.interpolateAttribute(value, JCEKSSecureCredentialsVault.defaultScv());
    }

    private String interpolateAttribute(String value, SecureCredentialsVault secureCredentialsVault) {
        if (value == null) {
            return null;
        }
        Interpolator.Result result = Interpolator.interpolate((String)value, (Scope)new FallbackScope(new Scope[]{new SecureCredentialsVaultScope(secureCredentialsVault), new EnvironmentScope()}));
        return result.output;
    }

    public String getFactory() {
        return this.factory != null ? this.factory : "org.opennms.core.db.HikariCPConnectionFactory";
    }

    public Integer getIdleTimeout() {
        String interpolated = this.interpolateAttribute(this.rawIdleTimeout);
        return interpolated != null ? Integer.parseInt(interpolated) : 600;
    }

    public Integer getLoginTimeout() {
        String interpolated = this.interpolateAttribute(this.rawLoginTimeout);
        return interpolated != null ? Integer.parseInt(interpolated) : 3;
    }

    public Integer getMaxPool() {
        String interpolated = this.interpolateAttribute(this.rawMaxPool);
        return interpolated != null ? Integer.parseInt(interpolated) : 50;
    }

    public Integer getMaxSize() {
        String interpolated = this.interpolateAttribute(this.rawMaxSize);
        return interpolated != null ? Integer.parseInt(interpolated) : 500;
    }

    public Integer getMinPool() {
        String interpolated = this.interpolateAttribute(this.rawMinPool);
        return interpolated != null ? Integer.parseInt(interpolated) : 10;
    }

    public boolean hasIdleTimeout() {
        return this.rawIdleTimeout != null;
    }

    public boolean hasLoginTimeout() {
        return this.rawLoginTimeout != null;
    }

    public boolean hasMaxPool() {
        return this.rawMaxPool != null;
    }

    public boolean hasMaxSize() {
        return this.rawMaxSize != null;
    }

    public boolean hasMinPool() {
        return this.rawMinPool != null;
    }

    public int hashCode() {
        return Objects.hash(this.factory, this.rawIdleTimeout, this.rawLoginTimeout, this.rawMinPool, this.rawMaxPool, this.rawMaxSize);
    }

    public void setFactory(String factory) {
        this.factory = factory;
    }

    public void setIdleTimeout(Integer idleTimeout) {
        this.rawIdleTimeout = idleTimeout != null ? idleTimeout.toString() : null;
    }

    public void setIdleTimeout(String idleTimeout) {
        this.rawIdleTimeout = idleTimeout;
    }

    public void setLoginTimeout(Integer loginTimeout) {
        this.rawLoginTimeout = loginTimeout != null ? loginTimeout.toString() : null;
    }

    public void setLoginTimeout(String loginTimeout) {
        this.rawLoginTimeout = loginTimeout;
    }

    public void setMaxPool(Integer maxPool) {
        this.rawMaxPool = maxPool != null ? maxPool.toString() : null;
    }

    public void setMaxPool(String maxPool) {
        this.rawMaxPool = maxPool;
    }

    public void setMaxSize(Integer maxSize) {
        this.rawMaxSize = maxSize != null ? maxSize.toString() : null;
    }

    public void setMaxSize(String maxSize) {
        this.rawMaxSize = maxSize;
    }

    public void setMinPool(Integer minPool) {
        this.rawMinPool = minPool != null ? minPool.toString() : null;
    }

    public void setMinPool(String minPool) {
        this.rawMinPool = minPool;
    }

    public static ConnectionPool merge(ConnectionPool a, ConnectionPool b) {
        if (b == null) {
            return a;
        }
        if (a == null) {
            return b;
        }
        ConnectionPool pool = new ConnectionPool();
        pool.factory = (String)MoreObjects.firstNonNull((Object)a.factory, (Object)b.factory);
        pool.rawIdleTimeout = (String)MoreObjects.firstNonNull((Object)a.rawIdleTimeout, (Object)b.rawIdleTimeout);
        pool.rawLoginTimeout = (String)MoreObjects.firstNonNull((Object)a.rawLoginTimeout, (Object)b.rawLoginTimeout);
        pool.rawMinPool = (String)MoreObjects.firstNonNull((Object)a.rawMinPool, (Object)b.rawMinPool);
        pool.rawMaxPool = (String)MoreObjects.firstNonNull((Object)a.rawMaxPool, (Object)b.rawMaxPool);
        pool.rawMaxSize = (String)MoreObjects.firstNonNull((Object)a.rawMaxSize, (Object)b.rawMaxSize);
        return pool;
    }
}

