/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.labels;

import io.pyroscope.labels.LabelsSet;
import io.pyroscope.labels.Ref;
import io.pyroscope.labels.RefCounted;
import io.pyroscope.labels.ScopedContext;
import io.pyroscope.labels.pb.JfrLabels;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;

public class Pyroscope {
    private static Map<String, String> staticLabels = Collections.emptyMap();

    public static void setStaticLabels(Map<String, String> labels) {
        staticLabels = Collections.unmodifiableMap(labels);
    }

    public static Map<String, String> getStaticLabels() {
        return staticLabels;
    }

    public static class LabelsWrapper {
        public static <T> T run(LabelsSet labels, Callable<T> c) throws Exception {
            try (ScopedContext s = new ScopedContext(labels);){
                T t = c.call();
                return t;
            }
        }

        public static void run(LabelsSet labels, Runnable c) {
            try (ScopedContext s = new ScopedContext(labels);){
                c.run();
            }
        }

        public static JfrLabels.Snapshot dump() {
            JfrLabels.Snapshot.Builder sb = JfrLabels.Snapshot.newBuilder();
            for (Ref it : RefCounted.strings.valueToRef.values()) {
                sb.putStrings(it.id, (String)it.val);
            }
            for (Ref it : RefCounted.contexts.valueToRef.values()) {
                JfrLabels.Context.Builder cb = JfrLabels.Context.newBuilder();
                for (Map.Entry kv : ((Map)it.val).entrySet()) {
                    cb.putLabels(((Ref)kv.getKey()).id, ((Ref)kv.getValue()).id);
                }
                sb.putContexts(it.id, cb.build());
            }
            RefCounted.contexts.gc();
            RefCounted.strings.gc();
            return sb.build();
        }
    }
}

