/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.datagram;

import java.net.DatagramPacket;
import org.opennms.netmgt.provision.detector.datagram.client.NtpClient;
import org.opennms.netmgt.provision.support.BasicDetector;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.RequestBuilder;
import org.opennms.netmgt.provision.support.ResponseValidator;
import org.opennms.netmgt.provision.support.ntp.NtpMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtpDetector
extends BasicDetector<NtpMessage, DatagramPacket> {
    private static final Logger LOG = LoggerFactory.getLogger(NtpDetector.class);
    private final NtpClient m_client = new NtpClient();

    public NtpDetector() {
        super("NTP", 123);
    }

    protected Client<NtpMessage, DatagramPacket> getClient() {
        return this.m_client;
    }

    protected void onInit() {
        this.send(this.createNtpMessage(), this.validateResponse());
    }

    private ResponseValidator<DatagramPacket> validateResponse() {
        return new ResponseValidator<DatagramPacket>(){

            public boolean validate(DatagramPacket response) {
                if (response.getAddress().equals(NtpDetector.this.m_client.getAddress())) {
                    NtpMessage m = new NtpMessage(response.getData());
                    LOG.info("NTP message received {}", (Object)m.toString());
                    return m.originateTimestamp > 0.0 && m.transmitTimestamp > 0.0 && m.referenceTimestamp > 0.0 && m.receiveTimestamp > 0.0;
                }
                return false;
            }
        };
    }

    private RequestBuilder<NtpMessage> createNtpMessage() {
        return new RequestBuilder<NtpMessage>(){

            public NtpMessage getRequest() {
                return new NtpMessage();
            }
        };
    }

    public void setIpToValidate(String address) {
    }

    public String getIpToValidate() {
        return null;
    }
}

