/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.ui.components.colorpicker;

import com.vaadin.shared.communication.ServerRpc;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Component;
import com.vaadin.v7.shared.ui.colorpicker.Color;
import com.vaadin.v7.shared.ui.colorpicker.ColorPickerGridServerRpc;
import com.vaadin.v7.shared.ui.colorpicker.ColorPickerGridState;
import com.vaadin.v7.ui.components.colorpicker.ColorChangeEvent;
import com.vaadin.v7.ui.components.colorpicker.ColorChangeListener;
import com.vaadin.v7.ui.components.colorpicker.ColorSelector;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;

@Deprecated
public class ColorPickerGrid
extends AbstractComponent
implements ColorSelector {
    private static final String STYLENAME = "v-colorpicker-grid";
    private static final Method COLOR_CHANGE_METHOD;
    private ColorPickerGridServerRpc rpc = new ColorPickerGridServerRpc(){

        public void select(int x, int y) {
            ColorPickerGrid.this.x = x;
            ColorPickerGrid.this.y = y;
            ColorPickerGrid.this.fireColorChanged(ColorPickerGrid.this.colorGrid[y][x]);
        }

        public void refresh() {
            for (int row = 0; row < ColorPickerGrid.this.rows; ++row) {
                for (int col = 0; col < ColorPickerGrid.this.columns; ++col) {
                    ColorPickerGrid.this.changedColors.put(new Point(row, col), ColorPickerGrid.this.colorGrid[row][col]);
                }
            }
            ColorPickerGrid.this.sendChangedColors();
            ColorPickerGrid.this.markAsDirty();
        }
    };
    private int x = 0;
    private int y = 0;
    private int rows;
    private int columns;
    private Color[][] colorGrid = new Color[1][1];
    private final Map<Point, Color> changedColors = new HashMap<Point, Color>();

    public ColorPickerGrid() {
        this.registerRpc((ServerRpc)this.rpc);
        this.setPrimaryStyleName(STYLENAME);
        this.setColorGrid(new Color[1][1]);
        this.setColor(Color.WHITE);
    }

    public ColorPickerGrid(int rows, int columns) {
        this.registerRpc((ServerRpc)this.rpc);
        this.setPrimaryStyleName(STYLENAME);
        this.setColorGrid(new Color[rows][columns]);
        this.setColor(Color.WHITE);
    }

    public ColorPickerGrid(Color[][] colors) {
        this.registerRpc((ServerRpc)this.rpc);
        this.setPrimaryStyleName(STYLENAME);
        this.setColorGrid(colors);
    }

    private void setColumnCount(int columns) {
        this.columns = columns;
        this.getState().columnCount = columns;
    }

    private void setRowCount(int rows) {
        this.rows = rows;
        this.getState().rowCount = rows;
    }

    private void sendChangedColors() {
        if (!this.changedColors.isEmpty()) {
            String[] colors = new String[this.changedColors.size()];
            String[] xCoords = new String[this.changedColors.size()];
            String[] yCoords = new String[this.changedColors.size()];
            int counter = 0;
            for (Point p : this.changedColors.keySet()) {
                String color;
                Color c = this.changedColors.get(p);
                if (c == null) continue;
                colors[counter] = color = c.getCSS();
                xCoords[counter] = String.valueOf(p.getX());
                yCoords[counter] = String.valueOf(p.getY());
                ++counter;
            }
            this.getState().changedColor = colors;
            this.getState().changedX = xCoords;
            this.getState().changedY = yCoords;
            this.changedColors.clear();
        }
    }

    public void setColorGrid(Color[][] colors) {
        this.setRowCount(colors.length);
        this.setColumnCount(colors[0].length);
        this.colorGrid = colors;
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.columns; ++col) {
                this.changedColors.put(new Point(row, col), this.colorGrid[row][col]);
            }
        }
        this.sendChangedColors();
        this.markAsDirty();
    }

    @Override
    public void addColorChangeListener(ColorChangeListener listener) {
        this.addListener(ColorChangeEvent.class, listener, COLOR_CHANGE_METHOD);
    }

    @Override
    public Color getColor() {
        return this.colorGrid[this.x][this.y];
    }

    @Override
    public void removeColorChangeListener(ColorChangeListener listener) {
        this.removeListener(ColorChangeEvent.class, listener);
    }

    @Override
    public void setColor(Color color) {
        this.colorGrid[this.x][this.y] = color;
        this.changedColors.put(new Point(this.x, this.y), color);
        this.sendChangedColors();
        this.markAsDirty();
    }

    public void setPosition(int x, int y) {
        if (x >= 0 && x < this.columns && y >= 0 && y < this.rows) {
            this.x = x;
            this.y = y;
        }
    }

    public int[] getPosition() {
        return new int[]{this.x, this.y};
    }

    public void fireColorChanged(Color color) {
        this.fireEvent((EventObject)((Object)new ColorChangeEvent((Component)this, color)));
    }

    protected ColorPickerGridState getState() {
        return (ColorPickerGridState)super.getState();
    }

    static {
        try {
            COLOR_CHANGE_METHOD = ColorChangeListener.class.getDeclaredMethod("colorChanged", ColorChangeEvent.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Internal error finding methods in ColorPicker");
        }
    }

    private static class Point
    implements Serializable {
        private int x;
        private int y;

        public Point(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }
}

