/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.mock.AbstractMockDao;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockIpInterfaceDao
extends AbstractMockDao<OnmsIpInterface, Integer>
implements IpInterfaceDao {
    private static final Logger LOG = LoggerFactory.getLogger(MockIpInterfaceDao.class);
    private AtomicInteger m_id = new AtomicInteger(0);

    @Override
    public Integer save(OnmsIpInterface iface) {
        this.updateParent(iface);
        Integer retval = (Integer)super.save(iface);
        this.updateSubObjects(iface);
        return retval;
    }

    @Override
    public void update(OnmsIpInterface iface) {
        this.updateParent(iface);
        super.update(iface);
        this.updateSubObjects(iface);
    }

    @Override
    public void flush() {
        super.flush();
        for (OnmsIpInterface iface : this.findAll()) {
            this.updateSubObjects(iface);
        }
    }

    private void updateParent(OnmsIpInterface iface) {
        OnmsNode node = null;
        if (iface.getNodeId() != null) {
            node = (OnmsNode)this.getNodeDao().get((Serializable)iface.getNodeId());
        } else if (iface.getNode() != null && (node = this.getNodeDao().findByForeignId(iface.getNode().getForeignSource(), iface.getNode().getForeignId())) == null) {
            node = this.getNodeDao().findByForeignId(iface.getNode().getForeignSource(), iface.getNode().getForeignId());
        }
        if (node != null && node != iface.getNode()) {
            LOG.debug("merging node {} into node {}", (Object)iface.getNode(), (Object)node);
            node.mergeNode(iface.getNode(), (EventForwarder)new AbstractMockDao.NullEventForwarder(), false);
            iface.setNode(node);
        }
        if (!iface.getNode().getIpInterfaces().contains(iface)) {
            LOG.debug("adding IP interface to node {}: {}", (Object)iface.getNode().getId(), (Object)iface);
            iface.getNode().addIpInterface(iface);
        }
    }

    private void updateSubObjects(OnmsIpInterface iface) {
        for (OnmsMonitoredService svc : iface.getMonitoredServices()) {
            this.getMonitoredServiceDao().saveOrUpdate((Object)svc);
        }
    }

    @Override
    public void delete(OnmsIpInterface iface) {
        super.delete(iface);
        for (OnmsMonitoredService svc : iface.getMonitoredServices()) {
            this.getMonitoredServiceDao().delete((Object)svc);
        }
    }

    @Override
    protected void generateId(OnmsIpInterface iface) {
        iface.setId(Integer.valueOf(this.m_id.incrementAndGet()));
    }

    @Override
    protected Integer getId(OnmsIpInterface iface) {
        return iface.getId();
    }

    public OnmsIpInterface get(OnmsNode node, String ipAddress) {
        for (OnmsIpInterface iface : this.findAll()) {
            if (!node.equals(iface.getNode()) || !ipAddress.equals(iface.getIpAddressAsString())) continue;
            return iface;
        }
        return null;
    }

    public OnmsIpInterface findByNodeIdAndIpAddress(Integer nodeId, String ipAddress) {
        for (OnmsIpInterface iface : this.findAll()) {
            if (!iface.getNode().getId().equals(nodeId) || !ipAddress.equals(iface.getIpAddressAsString())) continue;
            return iface;
        }
        return null;
    }

    public OnmsIpInterface findByForeignKeyAndIpAddress(String foreignSource, String foreignId, String ipAddress) {
        if (foreignId == null || ipAddress == null) {
            return null;
        }
        for (OnmsIpInterface iface : this.findAll()) {
            if (!Objects.equals(ipAddress, iface.getIpAddressAsString()) || !Objects.equals(foreignSource, iface.getForeignSource()) || !Objects.equals(foreignId, iface.getForeignId())) continue;
            return iface;
        }
        return null;
    }

    public List<OnmsIpInterface> findByIpAddress(String ipAddress) {
        ArrayList<OnmsIpInterface> ifaces = new ArrayList<OnmsIpInterface>();
        if (ipAddress == null) {
            return ifaces;
        }
        for (OnmsIpInterface iface : this.findAll()) {
            if (!ipAddress.equals(iface.getIpAddressAsString())) continue;
            ifaces.add(iface);
        }
        return ifaces;
    }

    public List<OnmsIpInterface> findByNodeId(Integer nodeId) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public List<OnmsIpInterface> findByServiceType(String svcName) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public List<OnmsIpInterface> findHierarchyByServiceType(String svcName) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public Map<InetAddress, Integer> getInterfacesForNodes() {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public OnmsIpInterface findPrimaryInterfaceByNodeId(Integer nodeId) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public List<OnmsIpInterface> findInterfacesWithMetadata(String context, String key, String value, boolean matchEnumeration) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public List<OnmsIpInterface> findByMacLinksOfNode(Integer nodeId) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public List<OnmsIpInterface> findByIpAddressAndLocation(String location, String address) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }
}

