/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.Type;
import org.opennms.netmgt.model.OnmsNode;

@Entity
@Table(name="bridgeMacLink")
@Filter(name="authorizedOnly", condition="exists (select distinct x.nodeid from node x join category_node cn on x.nodeid = cn.nodeid join category_group cg on cn.categoryId = cg.categoryId where x.nodeid = nodeid and cg.groupId in (:userGroups))")
public class BridgeMacLink
implements Serializable {
    private static final long serialVersionUID = 8100699538135896806L;
    private Integer m_id;
    private OnmsNode m_node;
    private Integer m_bridgePort;
    private Integer m_bridgePortIfIndex;
    private String m_bridgePortIfName;
    private String m_macAddress;
    private Integer m_vlan;
    private BridgeMacLinkType m_linkType;
    private Date m_bridgeMacLinkCreateTime = new Date();
    private Date m_bridgeMacLinkLastPollTime;

    @Id
    @Column(nullable=false)
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @Column(name="bridgePort", nullable=false)
    public Integer getBridgePort() {
        return this.m_bridgePort;
    }

    public void setBridgePort(Integer bridgePort) {
        this.m_bridgePort = bridgePort;
    }

    @Column(name="bridgePortIfIndex")
    public Integer getBridgePortIfIndex() {
        return this.m_bridgePortIfIndex;
    }

    public void setBridgePortIfIndex(Integer bridgePortIfIndex) {
        this.m_bridgePortIfIndex = bridgePortIfIndex;
    }

    @Column(name="bridgePortIfName", length=32)
    public String getBridgePortIfName() {
        return this.m_bridgePortIfName;
    }

    public void setBridgePortIfName(String bridgePortIfName) {
        this.m_bridgePortIfName = bridgePortIfName;
    }

    @Column(name="vlan")
    public Integer getVlan() {
        return this.m_vlan;
    }

    public void setVlan(Integer vlan) {
        this.m_vlan = vlan;
    }

    @Column(name="macAddress", length=12, nullable=false)
    public String getMacAddress() {
        return this.m_macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.m_macAddress = macAddress;
    }

    @Column(name="linkType", nullable=false)
    @Type(type="org.opennms.netmgt.enlinkd.model.BridgeMacLinkTypeUserType")
    public BridgeMacLinkType getLinkType() {
        return this.m_linkType;
    }

    public void setLinkType(BridgeMacLinkType linkType) {
        this.m_linkType = linkType;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="bridgeMacLinkCreateTime", nullable=false)
    public Date getBridgeMacLinkCreateTime() {
        return this.m_bridgeMacLinkCreateTime;
    }

    public void setBridgeMacLinkCreateTime(Date bridgeMacLinkCreateTime) {
        this.m_bridgeMacLinkCreateTime = bridgeMacLinkCreateTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="bridgeMacLinkLastPollTime", nullable=false)
    public Date getBridgeMacLinkLastPollTime() {
        return this.m_bridgeMacLinkLastPollTime;
    }

    public void setBridgeMacLinkLastPollTime(Date bridgeMacLinkLastPollTime) {
        this.m_bridgeMacLinkLastPollTime = bridgeMacLinkLastPollTime;
    }

    public String toString() {
        return "maclink: nodeid:[" + this.getNode().getId() + "], bridgeport:[" + this.getBridgePort() + "], ifindex:[" + this.getBridgePortIfIndex() + "], vlan:[" + this.getVlan() + "]," + this.getMacAddress() + "," + BridgeMacLinkType.getTypeString(this.getLinkType().getValue()) + "]";
    }

    public void merge(BridgeMacLink element) {
        if (element == null) {
            return;
        }
        this.setBridgePortIfIndex(element.getBridgePortIfIndex());
        this.setBridgePortIfName(element.getBridgePortIfName());
        this.setVlan(element.getVlan());
        this.setLinkType(element.getLinkType());
        if (element.getBridgeMacLinkLastPollTime() == null) {
            this.setBridgeMacLinkLastPollTime(element.getBridgeMacLinkCreateTime());
        } else {
            this.setBridgeMacLinkLastPollTime(element.getBridgeMacLinkLastPollTime());
        }
    }

    public static enum BridgeMacLinkType {
        BRIDGE_LINK(1),
        BRIDGE_FORWARDER(2);

        private final int m_type;
        protected static final Map<Integer, String> s_typeMap;

        private BridgeMacLinkType(int type) {
            this.m_type = type;
        }

        public static String getTypeString(Integer code) {
            if (s_typeMap.containsKey(code)) {
                return s_typeMap.get(code);
            }
            return null;
        }

        public Integer getValue() {
            return this.m_type;
        }

        public static BridgeMacLinkType get(Integer code) {
            if (code == null) {
                throw new IllegalArgumentException("Cannot create BridgeMacLinkType from null code");
            }
            switch (code) {
                case 1: {
                    return BRIDGE_LINK;
                }
                case 2: {
                    return BRIDGE_FORWARDER;
                }
            }
            throw new IllegalArgumentException("Cannot create BridgeMacLinkType from code " + code);
        }

        static {
            s_typeMap = new HashMap<Integer, String>();
            s_typeMap.put(1, "bridge-link");
            s_typeMap.put(2, "bridge-forwarder");
        }
    }
}

