/*
 * Decompiled with CFR 0.152.
 */
package rpc;

public final class Buffer {
    public static final int NO_INCREMENT = 0;
    private byte[] buffer;
    private int capacityIncrement = 0;
    private int index = 0;
    private int length;

    public Buffer() {
        this(null, 0);
    }

    public Buffer(int capacityIncrement) {
        this(null, capacityIncrement);
    }

    public Buffer(byte[] buffer) {
        this(buffer, 0);
    }

    public Buffer(byte[] buffer, int capacityIncrement) {
        this.setBuffer(buffer);
        this.setCapacityIncrement(capacityIncrement);
    }

    public int getCapacity() {
        return this.buffer.length;
    }

    public int getCapacityIncrement() {
        return this.capacityIncrement;
    }

    public void setCapacityIncrement(int capacityIncrement) {
        this.capacityIncrement = capacityIncrement;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void setBuffer(byte[] buffer) {
        this.buffer = buffer != null ? buffer : new byte[]{};
        this.index = 0;
        this.length = 0;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
        if (length > this.buffer.length) {
            this.grow(length);
        }
    }

    public byte[] copy() {
        byte[] copy = new byte[this.length];
        System.arraycopy(this.buffer, 0, copy, 0, this.length);
        return copy;
    }

    public void reset() {
        this.length = 0;
        this.index = 0;
    }

    public int getIndex() {
        return this.index;
    }

    public int getIndex(int advance) {
        try {
            int n = this.index;
            return n;
        }
        finally {
            this.index += advance;
            if (this.index > this.length) {
                this.length = this.index;
            }
            if (this.length > this.buffer.length) {
                this.grow(this.length);
            }
        }
    }

    public void setIndex(int index) {
        this.index = index;
        if (index > this.length) {
            this.length = index;
        }
        if (this.length > this.buffer.length) {
            this.grow(this.length);
        }
    }

    public int align(int boundary) {
        int align = this.index % boundary;
        if (align == 0) {
            return 0;
        }
        align = boundary - align;
        this.advance(align);
        return align;
    }

    public int align(int boundary, byte value) {
        int align = this.index % boundary;
        if (align == 0) {
            return 0;
        }
        align = boundary - align;
        this.advance(align, value);
        return align;
    }

    public int advance(int step) {
        this.index += step;
        if (this.index > this.length) {
            this.length = this.index;
        }
        if (this.length > this.buffer.length) {
            this.grow(this.length);
        }
        return this.index;
    }

    public int advance(int step, byte value) {
        int finish = this.index + step;
        while (this.index < finish) {
            this.buffer[this.index] = value;
            ++this.index;
        }
        if (this.index > this.length) {
            this.length = this.index;
        }
        if (this.length > this.buffer.length) {
            this.grow(this.length);
        }
        return this.index;
    }

    private void grow(int length) {
        int newLength;
        if (this.capacityIncrement <= 0) {
            throw new IndexOutOfBoundsException();
        }
        for (newLength = this.buffer.length; newLength < length; newLength += this.capacityIncrement) {
        }
        byte[] newBuffer = new byte[newLength];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
        this.buffer = newBuffer;
    }
}

