/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.io.IOUtils;
import org.opennms.core.network.IpListFromUrl;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.ConfigObjectRetrievalFailureException;
import org.opennms.netmgt.config.DefaultServiceMonitorLocator;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.CriticalService;
import org.opennms.netmgt.config.poller.IncludeRange;
import org.opennms.netmgt.config.poller.Monitor;
import org.opennms.netmgt.config.poller.NodeOutage;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.PollerConfiguration;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.ServiceMonitorLocator;
import org.opennms.netmgt.poller.ServiceMonitorRegistry;
import org.opennms.netmgt.poller.support.DefaultServiceMonitorRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PollerConfigManager
implements PollerConfig {
    private static final Logger LOG = LoggerFactory.getLogger(PollerConfigManager.class);
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    private List<Package> externalPackages = new ArrayList<Package>();
    private List<Package> mergedPackages = new ArrayList<Package>();
    private List<Monitor> externalMonitors = new ArrayList<Monitor>();
    private List<Monitor> mergedMonitors = new ArrayList<Monitor>();
    private static final ServiceMonitorRegistry s_serviceMonitorRegistry = new DefaultServiceMonitorRegistry();
    protected PollerConfiguration m_config;
    private Map<String, List<String>> m_urlIPMap;
    private AtomicReference<Map<Package, Set<InetAddress>>> m_pkgIpMap = new AtomicReference();

    @Override
    public void setExternalData(List<Package> externalPackages, List<Monitor> externalMonitors) {
        try {
            this.getWriteLock().lock();
            this.externalPackages = externalPackages;
            this.externalMonitors = externalMonitors;
            this.setUpInternalData();
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    public PollerConfigManager(InputStream stream) {
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(stream);
            this.m_config = (PollerConfiguration)JaxbUtils.unmarshal(PollerConfiguration.class, (Reader)isr);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(isr);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)isr);
        this.setUpInternalData();
    }

    @Override
    public Lock getReadLock() {
        return this.m_readLock;
    }

    @Override
    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    protected void setUpInternalData() {
        this.getReadLock().lock();
        try {
            this.mergedMonitors = ListUtils.union((List)this.m_config.getMonitors(), this.externalMonitors);
            this.mergedPackages = ListUtils.union((List)this.m_config.getPackages(), this.externalPackages);
            this.createUrlIpMap();
            this.createPackageIpListMap();
            this.initializeServiceMonitors();
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public void update() throws IOException {
        this.setUpInternalData();
    }

    protected abstract void saveXml(String var1) throws IOException;

    private void createUrlIpMap() {
        this.m_urlIPMap = new HashMap<String, List<String>>();
        for (Package pkg : this.packages()) {
            for (String url : this.includeURLs(pkg)) {
                List iplist = IpListFromUrl.fetch((String)url);
                if (iplist.size() <= 0) continue;
                this.m_urlIPMap.put(url, iplist);
            }
        }
    }

    @Override
    public void save() throws IOException {
        try {
            this.getWriteLock().lock();
            this.saveXml(JaxbUtils.marshal((Object)this.m_config));
            this.update();
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    @Override
    public PollerConfiguration getLocalConfiguration() {
        try {
            this.getReadLock().lock();
            PollerConfiguration pollerConfiguration = this.m_config;
            return pollerConfiguration;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public PollerConfiguration getExtendedConfiguration() {
        return new ReadOnlyProxyPollerConfiguration(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Package getPackage(String name) {
        try {
            this.getReadLock().lock();
            for (Package pkg : this.packages()) {
                if (!pkg.getName().equals(name)) continue;
                Package package_ = pkg;
                return package_;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return null;
    }

    @Override
    public void addPackage(Package pkg) {
        try {
            this.getWriteLock().lock();
            this.m_config.addPackage(pkg);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    private boolean interfaceInUrl(String addr, String url) {
        boolean bRet = false;
        List<String> iplist = this.m_urlIPMap.get(url);
        if (iplist != null && iplist.size() > 0) {
            bRet = iplist.contains(addr);
        }
        return bRet;
    }

    public boolean isPathOutageEnabled() {
        try {
            this.getReadLock().lock();
            boolean bl = Boolean.valueOf(this.m_config.getPathOutageEnabled());
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public int getDefaultCriticalPathRetries() {
        try {
            this.getReadLock().lock();
            int n = this.m_config.getDefaultCriticalPathRetries();
            return n;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public int getDefaultCriticalPathTimeout() {
        try {
            this.getReadLock().lock();
            int n = this.m_config.getDefaultCriticalPathTimeout();
            return n;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public InetAddress getDefaultCriticalPathIp() {
        try {
            this.getReadLock().lock();
            InetAddress inetAddress = this.m_config.getDefaultCriticalPathIp();
            return inetAddress;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public String getCriticalService() {
        try {
            this.getReadLock().lock();
            CriticalService service = this.m_config.getNodeOutage().getCriticalService();
            String string = service == null ? null : service.getName();
            return string;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public boolean shouldPollAllIfNoCriticalServiceDefined() {
        try {
            this.getReadLock().lock();
            boolean bl = Boolean.valueOf(this.m_config.getNodeOutage().getPollAllIfNoCriticalServiceDefined());
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public boolean isNodeOutageProcessingEnabled() {
        try {
            this.getReadLock().lock();
            boolean bl = this.m_config.getNodeOutage().getStatus().equals("on");
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public boolean isServiceUnresponsiveEnabled() {
        try {
            this.getReadLock().lock();
            boolean bl = Boolean.valueOf(this.m_config.getServiceUnresponsiveEnabled());
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPackageIpListMap() {
        this.getReadLock().lock();
        try {
            HashMap<Package, HashSet<InetAddress>> pkgIpMap = new HashMap<Package, HashSet<InetAddress>>();
            for (Package pkg : this.packages()) {
                try {
                    HashSet<InetAddress> ipList = new HashSet<InetAddress>(this.getIpList(pkg));
                    LOG.debug("createPackageIpMap: package {}: ipList size = {}", (Object)pkg.getName(), (Object)ipList.size());
                    if (ipList.size() <= 0) continue;
                    pkgIpMap.put(pkg, ipList);
                }
                catch (Throwable t) {
                    LOG.error("createPackageIpMap: failed to map package: {} to an IP List with filter \"{}\"", new Object[]{pkg.getName(), pkg.getFilter().getContent(), t});
                    throw Throwables.propagate((Throwable)t);
                }
            }
            this.m_pkgIpMap.set(pkgIpMap);
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InetAddress> getIpList(Package pkg) {
        try {
            this.getReadLock().lock();
            String filterRules = pkg.getFilter().getContent();
            LOG.debug("createPackageIpMap: package is {}. filter rules are {}", (Object)pkg.getName(), (Object)filterRules);
            List list = FilterDaoFactory.getInstance().getActiveIPAddressList(filterRules);
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public void rebuildPackageIpListMap() {
        FilterDaoFactory.getInstance().flushActiveIpAddressListCache();
        this.createPackageIpListMap();
    }

    @Override
    public boolean isInterfaceInPackage(String iface, Package pkg) {
        int endComparison;
        int comparison;
        boolean filterPassed = false;
        InetAddress ifaceAddr = InetAddressUtils.addr((String)iface);
        Set<InetAddress> ipList = this.m_pkgIpMap.get().get(pkg);
        if (ipList != null && ipList.size() > 0) {
            filterPassed = ipList.contains(ifaceAddr);
        }
        LOG.debug("interfaceInPackage: Interface {} passed filter for package {}?: {}", new Object[]{iface, pkg.getName(), filterPassed});
        if (!filterPassed) {
            return false;
        }
        boolean has_specific = false;
        boolean has_range_include = false;
        boolean has_range_exclude = false;
        has_range_include = pkg.getIncludeRanges().size() == 0 && pkg.getSpecifics().size() == 0 && pkg.getIncludeUrls().size() == 0;
        byte[] addr = InetAddressUtils.toIpAddrBytes((String)iface);
        for (IncludeRange rng : pkg.getIncludeRanges()) {
            comparison = new ByteArrayComparator().compare(addr, InetAddressUtils.toIpAddrBytes((String)rng.getBegin()));
            if (comparison > 0) {
                endComparison = new ByteArrayComparator().compare(addr, InetAddressUtils.toIpAddrBytes((String)rng.getEnd()));
                if (endComparison > 0) continue;
                has_range_include = true;
                break;
            }
            if (comparison != 0) continue;
            has_range_include = true;
            break;
        }
        for (String spec : pkg.getSpecifics()) {
            if (new ByteArrayComparator().compare(addr, InetAddressUtils.toIpAddrBytes((String)spec)) != 0) continue;
            has_specific = true;
            LOG.debug("interfaceInPackage: Interface {} defined as 'specific'", (Object)iface);
            break;
        }
        for (String includeUrl : pkg.getIncludeUrls()) {
            if (!this.interfaceInUrl(iface, includeUrl)) continue;
            has_specific = true;
            LOG.debug("interfaceInPackage: Interface {} exist on {}", (Object)iface, (Object)includeUrl);
            break;
        }
        if (!has_specific) {
            for (IncludeRange rng : pkg.getExcludeRanges()) {
                comparison = new ByteArrayComparator().compare(addr, InetAddressUtils.toIpAddrBytes((String)rng.getBegin()));
                if (comparison > 0) {
                    endComparison = new ByteArrayComparator().compare(addr, InetAddressUtils.toIpAddrBytes((String)rng.getEnd()));
                    if (endComparison > 0) continue;
                    LOG.debug("interfaceInPackage: Interface {} matches an exclude range", (Object)iface);
                    has_range_exclude = true;
                    break;
                }
                if (comparison != 0) continue;
                LOG.debug("interfaceInPackage: Interface {} matches an exclude range", (Object)iface);
                has_range_exclude = true;
                break;
            }
        }
        return has_specific || has_range_include && !has_range_exclude;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isServiceInPackageAndEnabled(String svcName, Package pkg) {
        try {
            String status;
            this.getReadLock().lock();
            if (pkg == null) {
                LOG.warn("serviceInPackageAndEnabled:  pkg argument is NULL!!");
                boolean bl = false;
                return bl;
            }
            LOG.debug("serviceInPackageAndEnabled: svcName={} pkg={}", (Object)svcName, (Object)pkg.getName());
            for (Service svc : this.services(pkg)) {
                if (!svc.getName().equalsIgnoreCase(svcName) || (status = svc.getStatus()) != null && !status.equals("on")) continue;
                boolean bl = true;
                return bl;
            }
            for (Service svc : this.services(pkg)) {
                if (Strings.isNullOrEmpty((String)svc.getPattern()) || !Pattern.matches(svc.getPattern(), svcName) || (status = svc.getStatus()) != null && !status.equals("on")) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Service getServiceInPackage(String svcName, Package pkg) {
        try {
            this.getReadLock().lock();
            for (Service svc : this.services(pkg)) {
                if (!svcName.equals(svc.getName())) continue;
                Service service = svc;
                return service;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isServiceMonitored(String svcName) {
        try {
            this.getReadLock().lock();
            for (Monitor monitor : this.monitors()) {
                if (!monitor.getService().equals(svcName)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Package getFirstLocalPackageMatch(String ipaddr) {
        try {
            this.getReadLock().lock();
            for (Package pkg : this.packages()) {
                if (pkg.getPerspectiveOnly() || !this.isInterfaceInPackage(ipaddr, pkg)) continue;
                Package package_ = pkg;
                return package_;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllPackageMatches(String ipaddr) {
        ArrayList<String> matchingPkgs = new ArrayList<String>();
        try {
            this.getReadLock().lock();
            for (Package pkg : this.packages()) {
                if (!this.isInterfaceInPackage(ipaddr, pkg)) continue;
                matchingPkgs.add(pkg.getName());
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return matchingPkgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPolled(String ipaddr) {
        try {
            this.getReadLock().lock();
            for (Package pkg : this.packages()) {
                if (!this.isInterfaceInPackage(ipaddr, pkg)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPolledLocally(String ipaddr) {
        try {
            this.getReadLock().lock();
            for (Package pkg : this.packages()) {
                if (pkg.getPerspectiveOnly() || !this.isInterfaceInPackage(ipaddr, pkg)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return false;
    }

    @Override
    public boolean isPolled(String svcName, Package pkg) {
        if (this.isServiceInPackageAndEnabled(svcName, pkg)) {
            return this.isServiceMonitored(svcName);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPolled(String ipaddr, String svcName) {
        try {
            this.getReadLock().lock();
            if (!this.isServiceMonitored(svcName)) {
                boolean bl = false;
                return bl;
            }
            for (Package pkg : this.packages()) {
                if (!this.isServiceInPackageAndEnabled(svcName, pkg) || !this.isInterfaceInPackage(ipaddr, pkg)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPolledLocally(String ipaddr, String svcName) {
        try {
            this.getReadLock().lock();
            if (!this.isServiceMonitored(svcName)) {
                boolean bl = false;
                return bl;
            }
            for (Package pkg : this.packages()) {
                if (!this.isServiceInPackageAndEnabled(svcName, pkg) || !this.isInterfaceInPackage(ipaddr, pkg)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return false;
    }

    @Override
    public int getStep(Package pkg) {
        try {
            this.getReadLock().lock();
            int n = pkg.getRrd().getStep();
            return n;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public List<String> getRRAList(Package pkg) {
        try {
            this.getReadLock().lock();
            List list = pkg.getRrd().getRras();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public Enumeration<Package> enumeratePackage() {
        try {
            this.getReadLock().lock();
            Enumeration<Package> enumeration = Collections.enumeration(this.mergedPackages);
            return enumeration;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public List<Package> getPackages() {
        try {
            this.getReadLock().lock();
            List<Package> list = this.mergedPackages;
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    private Iterable<Service> services(Package pkg) {
        try {
            this.getReadLock().lock();
            List list = pkg.getServices();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    private Iterable<String> includeURLs(Package pkg) {
        try {
            this.getReadLock().lock();
            List list = pkg.getIncludeUrls();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public Iterable<Parameter> parameters(Service svc) {
        try {
            this.getReadLock().lock();
            List list = svc.getParameters();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    private Iterable<Package> packages() {
        try {
            this.getReadLock().lock();
            List<Package> list = this.mergedPackages;
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    private Collection<Monitor> monitors() {
        try {
            this.getReadLock().lock();
            List<Monitor> list = this.mergedMonitors;
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public int getThreads() {
        try {
            this.getReadLock().lock();
            int n = this.m_config.getThreads();
            return n;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    private void initializeServiceMonitors() {
        LOG.debug("start: Loading monitors");
        Collection<ServiceMonitorLocator> locators = this.getServiceMonitorLocators();
        for (ServiceMonitorLocator locator : locators) {
            ServiceMonitor monitor = locator.getServiceMonitor(s_serviceMonitorRegistry);
            if (monitor != null) continue;
            LOG.warn("The monitor with class {} not available yet, if the feature is installed correctly it will be available later.", (Object)locator.getServiceName());
        }
    }

    @Override
    public Set<String> getServiceMonitorNames() {
        try {
            this.getReadLock().lock();
            Set<String> set = this.monitors().stream().map(Monitor::getService).collect(Collectors.toSet());
            return set;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<ServiceMonitorLocator> getServiceMonitorLocator(String svcName) {
        try {
            this.getReadLock().lock();
            for (Monitor monitor : this.monitors()) {
                if (!Objects.equals(monitor.getService(), svcName)) continue;
                Optional<ServiceMonitorLocator> optional = Optional.of(new DefaultServiceMonitorLocator(monitor.getService(), monitor.getClassName()));
                return optional;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ServiceMonitorLocator> getServiceMonitorLocators() {
        ArrayList<ServiceMonitorLocator> locators = new ArrayList<ServiceMonitorLocator>();
        try {
            this.getReadLock().lock();
            for (Monitor monitor : this.monitors()) {
                try {
                    DefaultServiceMonitorLocator locator = new DefaultServiceMonitorLocator(monitor.getService(), monitor.getClassName());
                    locators.add(locator);
                    LOG.debug("Loaded monitor for service: {}, class-name: {}", (Object)monitor.getService(), (Object)monitor.getClassName());
                }
                catch (ConfigObjectRetrievalFailureException e) {
                    LOG.warn("{} {}", new Object[]{e.getMessage(), e.getRootCause(), e});
                }
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return locators;
    }

    @Override
    public ServiceMonitorRegistry getServiceMonitorRegistry() {
        return s_serviceMonitorRegistry;
    }

    @Override
    public String getNextOutageIdSql() {
        try {
            this.getReadLock().lock();
            String string = this.m_config.getNextOutageId();
            return string;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public boolean isAsyncEngineEnabled() {
        try {
            this.getReadLock().lock();
            boolean bl = this.m_config.getAsyncPollingEngineEnabled();
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public int getMaxConcurrentAsyncPolls() {
        try {
            this.getReadLock().lock();
            int n = this.m_config.getMaxConcurrentAsyncPolls();
            return n;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public static class ReadOnlyProxyPollerConfiguration
    extends PollerConfiguration {
        private static final String MESSAGE = "Modifying is not allowed in ReadOnlyProxyPollerConfiguration";
        private final PollerConfigManager pollerConfigManager;

        ReadOnlyProxyPollerConfiguration(PollerConfigManager pollerConfigManager) {
            this.pollerConfigManager = Objects.requireNonNull(pollerConfigManager);
        }

        public List<Package> getPackages() {
            return this.pollerConfigManager.mergedPackages;
        }

        public void setPackages(List<Package> packages) {
            throw new UnsupportedOperationException(MESSAGE);
        }

        public void addPackage(Package pack) throws IndexOutOfBoundsException {
            throw new UnsupportedOperationException(MESSAGE);
        }

        public boolean removePackage(Package pack) {
            throw new UnsupportedOperationException(MESSAGE);
        }

        public Package getPackage(String packageName) {
            return super.getPackage(packageName);
        }

        public List<Monitor> getMonitors() {
            return this.pollerConfigManager.mergedMonitors;
        }

        public void setMonitors(List<Monitor> monitors) {
            throw new UnsupportedOperationException(MESSAGE);
        }

        public void addMonitor(Monitor monitor) throws IndexOutOfBoundsException {
            throw new UnsupportedOperationException(MESSAGE);
        }

        public void addMonitor(String service, String className) {
            throw new UnsupportedOperationException(MESSAGE);
        }

        public boolean removeMonitor(Monitor monitor) {
            throw new UnsupportedOperationException(MESSAGE);
        }

        public Integer getThreads() {
            return this.pollerConfigManager.m_config.getThreads();
        }

        public void setThreads(Integer threads) {
            throw new UnsupportedOperationException(MESSAGE);
        }

        public String getNextOutageId() {
            return this.pollerConfigManager.m_config.getNextOutageId();
        }

        public void setNextOutageId(String nextOutageId) {
            throw new UnsupportedOperationException(MESSAGE);
        }

        public String getServiceUnresponsiveEnabled() {
            return this.pollerConfigManager.m_config.getServiceUnresponsiveEnabled();
        }

        public void setServiceUnresponsiveEnabled(String serviceUnresponsiveEnabled) {
            throw new UnsupportedOperationException(MESSAGE);
        }

        public String getPathOutageEnabled() {
            return this.pollerConfigManager.m_config.getPathOutageEnabled();
        }

        public void setPathOutageEnabled(String pathOutageEnabled) {
            throw new UnsupportedOperationException(MESSAGE);
        }

        public NodeOutage getNodeOutage() {
            return this.pollerConfigManager.m_config.getNodeOutage();
        }

        public void setNodeOutage(NodeOutage nodeOutage) {
            throw new UnsupportedOperationException(MESSAGE);
        }

        public PollerConfiguration getPollerConfigurationForPackages(List<String> pollingPackageNames) {
            return this.pollerConfigManager.m_config.getPollerConfigurationForPackages(pollingPackageNames);
        }

        public InetAddress getDefaultCriticalPathIp() {
            return this.pollerConfigManager.m_config.getDefaultCriticalPathIp();
        }

        public void setDefaultCriticalPathIp(InetAddress ip) {
            throw new UnsupportedOperationException(MESSAGE);
        }

        public Integer getDefaultCriticalPathTimeout() {
            return this.pollerConfigManager.m_config.getDefaultCriticalPathTimeout();
        }

        public void setDefaultCriticalPathTimeout(Integer timeout) {
            throw new UnsupportedOperationException(MESSAGE);
        }

        public int getDefaultCriticalPathRetries() {
            return this.pollerConfigManager.m_config.getDefaultCriticalPathRetries();
        }

        public void setDefaultCriticalPathRetries(Integer retries) {
            throw new UnsupportedOperationException(MESSAGE);
        }
    }
}

