/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml.context;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.opensaml.saml2.encryption.Decrypter;
import org.opensaml.saml2.encryption.EncryptedElementTypeEncryptedKeyResolver;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.encryption.ChainingEncryptedKeyResolver;
import org.opensaml.xml.encryption.EncryptedKeyResolver;
import org.opensaml.xml.encryption.InlineEncryptedKeyResolver;
import org.opensaml.xml.encryption.SimpleRetrievalMethodEncryptedKeyResolver;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.StaticKeyInfoCredentialResolver;
import org.opensaml.xml.security.trust.ExplicitX509CertificateTrustEngine;
import org.opensaml.xml.security.trust.TrustEngine;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.security.x509.BasicX509CredentialNameEvaluator;
import org.opensaml.xml.security.x509.PKIXTrustEvaluator;
import org.opensaml.xml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.xml.security.x509.PKIXX509CredentialTrustEngine;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.security.x509.X509CredentialNameEvaluator;
import org.opensaml.xml.signature.SignatureTrustEngine;
import org.opensaml.xml.signature.impl.ExplicitKeySignatureTrustEngine;
import org.opensaml.xml.signature.impl.PKIXSignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.saml.context.SAMLContextProvider;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.security.saml.key.KeyManager;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.MetadataManager;
import org.springframework.security.saml.storage.HttpSessionStorageFactory;
import org.springframework.security.saml.storage.SAMLMessageStorageFactory;
import org.springframework.security.saml.trust.CertPathPKIXTrustEvaluator;
import org.springframework.security.saml.trust.MetadataCredentialResolver;
import org.springframework.security.saml.trust.PKIXInformationResolver;
import org.springframework.security.saml.util.SAMLUtil;
import org.springframework.util.Assert;

public class SAMLContextProviderImpl
implements SAMLContextProvider,
InitializingBean {
    protected static final Logger log = LoggerFactory.getLogger(SAMLContextProviderImpl.class);
    private static ChainingEncryptedKeyResolver encryptedKeyResolver = new ChainingEncryptedKeyResolver();
    protected KeyManager keyManager;
    protected MetadataManager metadata;
    protected org.opensaml.security.MetadataCredentialResolver metadataResolver;
    protected PKIXValidationInformationResolver pkixResolver;
    protected PKIXTrustEvaluator pkixTrustEvaluator;
    protected SAMLMessageStorageFactory storageFactory = new HttpSessionStorageFactory();

    @Override
    public SAMLMessageContext getLocalEntity(HttpServletRequest request, HttpServletResponse response) throws MetadataProviderException {
        SAMLMessageContext context = new SAMLMessageContext();
        this.populateGenericContext(request, response, context);
        this.populateLocalEntityId(context, request.getRequestURI());
        this.populateLocalContext(context);
        return context;
    }

    @Override
    public SAMLMessageContext getLocalAndPeerEntity(HttpServletRequest request, HttpServletResponse response) throws MetadataProviderException {
        SAMLMessageContext context = new SAMLMessageContext();
        this.populateGenericContext(request, response, context);
        this.populateLocalEntityId(context, request.getRequestURI());
        this.populateLocalContext(context);
        this.populatePeerEntityId(context);
        this.populatePeerContext(context);
        return context;
    }

    protected void populatePeerEntityId(SAMLMessageContext context) throws MetadataProviderException {
        HTTPInTransport inTransport = (HTTPInTransport)context.getInboundMessageTransport();
        String entityId = (String)inTransport.getAttribute("peerEntityId");
        if (entityId != null) {
            log.debug("Using protocol specified IDP {}", (Object)entityId);
        } else {
            entityId = inTransport.getParameterValue("idp");
            if (entityId != null) {
                log.debug("Using user specified IDP {} from request", (Object)entityId);
                context.setPeerUserSelected(true);
            } else {
                entityId = this.metadata.getDefaultIDP();
                log.debug("No IDP specified, using default {}", (Object)entityId);
                context.setPeerUserSelected(false);
            }
        }
        context.setPeerEntityId(entityId);
        context.setPeerEntityRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
    }

    protected void populatePeerContext(SAMLMessageContext samlContext) throws MetadataProviderException {
        String peerEntityId = samlContext.getPeerEntityId();
        QName peerEntityRole = samlContext.getPeerEntityRole();
        if (peerEntityId == null) {
            throw new MetadataProviderException("Peer entity ID wasn't specified, but is requested");
        }
        EntityDescriptor entityDescriptor = this.metadata.getEntityDescriptor(peerEntityId);
        RoleDescriptor roleDescriptor = this.metadata.getRole(peerEntityId, peerEntityRole, "urn:oasis:names:tc:SAML:2.0:protocol");
        ExtendedMetadata extendedMetadata = this.metadata.getExtendedMetadata(peerEntityId);
        if (entityDescriptor == null || roleDescriptor == null) {
            throw new MetadataProviderException("Metadata for entity " + peerEntityId + " and role " + peerEntityRole + " wasn't found");
        }
        samlContext.setPeerEntityMetadata(entityDescriptor);
        samlContext.setPeerEntityRoleMetadata(roleDescriptor);
        samlContext.setPeerExtendedMetadata(extendedMetadata);
    }

    protected void populateGenericContext(HttpServletRequest request, HttpServletResponse response, SAMLMessageContext context) throws MetadataProviderException {
        HttpServletRequestAdapter inTransport = new HttpServletRequestAdapter(request);
        HttpServletResponseAdapter outTransport = new HttpServletResponseAdapter(response, request.isSecure());
        request.setAttribute("localContextPath", (Object)request.getContextPath());
        context.setMetadataProvider((MetadataProvider)this.metadata);
        context.setInboundMessageTransport((InTransport)inTransport);
        context.setOutboundMessageTransport((OutTransport)outTransport);
        context.setMessageStorage(this.storageFactory.getMessageStorage(request));
    }

    protected void populateLocalContext(SAMLMessageContext context) throws MetadataProviderException {
        this.populateLocalEntity(context);
        this.populateDecrypter(context);
        this.populateSSLCredential(context);
        this.populatePeerSSLCredential(context);
        this.populateTrustEngine(context);
        this.populateSSLTrustEngine(context);
        this.populateSSLHostnameVerifier(context);
    }

    protected void populateLocalEntityId(SAMLMessageContext context, String requestURI) throws MetadataProviderException {
        int filterIndex;
        HTTPInTransport inTransport = (HTTPInTransport)context.getInboundMessageTransport();
        String entityId = (String)inTransport.getAttribute("localEntityId");
        if (entityId != null) {
            log.debug("Using protocol specified SP {}", (Object)entityId);
            context.setLocalEntityId(entityId);
            context.setLocalEntityRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
            return;
        }
        if (requestURI == null) {
            requestURI = "";
        }
        if ((filterIndex = requestURI.indexOf("/alias/")) != -1) {
            QName localEntityRole;
            String localAlias = requestURI.substring(filterIndex + 7);
            int entityTypePosition = localAlias.lastIndexOf(47);
            if (entityTypePosition != -1) {
                String entityRole = localAlias.substring(entityTypePosition + 1);
                localEntityRole = "idp".equalsIgnoreCase(entityRole) ? IDPSSODescriptor.DEFAULT_ELEMENT_NAME : SPSSODescriptor.DEFAULT_ELEMENT_NAME;
                localAlias = localAlias.substring(0, entityTypePosition);
            } else {
                localEntityRole = SPSSODescriptor.DEFAULT_ELEMENT_NAME;
            }
            entityId = this.metadata.getEntityIdForAlias(localAlias);
            if (entityId == null) {
                throw new MetadataProviderException("No local entity found for alias " + localAlias + ", verify your configuration.");
            }
            log.debug("Using SP {} specified in request with alias {}", (Object)entityId, (Object)localAlias);
            context.setLocalEntityId(entityId);
            context.setLocalEntityRole(localEntityRole);
        } else {
            context.setLocalEntityId(this.getDefaultLocalEntityId(context, requestURI));
            context.setLocalEntityRole(this.getDefaultLocalEntityRole(context, requestURI));
        }
    }

    protected String getDefaultLocalEntityId(SAMLMessageContext context, String requestURI) throws MetadataProviderException {
        return this.metadata.getHostedSPName();
    }

    protected QName getDefaultLocalEntityRole(SAMLMessageContext context, String requestURI) throws MetadataProviderException {
        return SPSSODescriptor.DEFAULT_ELEMENT_NAME;
    }

    protected void populateLocalEntity(SAMLMessageContext samlContext) throws MetadataProviderException {
        String localEntityId = samlContext.getLocalEntityId();
        QName localEntityRole = samlContext.getLocalEntityRole();
        if (localEntityId == null) {
            throw new MetadataProviderException("No hosted service provider is configured and no alias was selected");
        }
        EntityDescriptor entityDescriptor = this.metadata.getEntityDescriptor(localEntityId);
        RoleDescriptor roleDescriptor = this.metadata.getRole(localEntityId, localEntityRole, "urn:oasis:names:tc:SAML:2.0:protocol");
        ExtendedMetadata extendedMetadata = this.metadata.getExtendedMetadata(localEntityId);
        if (entityDescriptor == null || roleDescriptor == null) {
            throw new MetadataProviderException("Metadata for entity " + localEntityId + " and role " + localEntityRole + " wasn't found");
        }
        samlContext.setLocalEntityMetadata(entityDescriptor);
        samlContext.setLocalEntityRoleMetadata(roleDescriptor);
        samlContext.setLocalExtendedMetadata(extendedMetadata);
        if (extendedMetadata.getSigningKey() != null) {
            samlContext.setLocalSigningCredential(this.keyManager.getCredential(extendedMetadata.getSigningKey()));
        } else {
            samlContext.setLocalSigningCredential(this.keyManager.getDefaultCredential());
        }
    }

    protected void populateSSLCredential(SAMLMessageContext samlContext) {
        X509Credential tlsCredential = samlContext.getLocalExtendedMetadata().getTlsKey() != null ? (X509Credential)this.keyManager.getCredential(samlContext.getLocalExtendedMetadata().getTlsKey()) : null;
        samlContext.setLocalSSLCredential(tlsCredential);
    }

    protected void populateSSLHostnameVerifier(SAMLMessageContext samlContext) {
        HostnameVerifier hostnameVerifier = SAMLUtil.getHostnameVerifier(samlContext.getLocalExtendedMetadata().getSslHostnameVerification());
        samlContext.setGetLocalSSLHostnameVerifier(hostnameVerifier);
    }

    protected void populatePeerSSLCredential(SAMLMessageContext samlContext) {
        X509Certificate[] chain = (X509Certificate[])samlContext.getInboundMessageTransport().getAttribute("javax.servlet.request.X509Certificate");
        if (chain != null && chain.length > 0) {
            log.debug("Found certificate chain from request {}", (Object)chain[0]);
            BasicX509Credential credential = new BasicX509Credential();
            credential.setEntityCertificate(chain[0]);
            credential.setEntityCertificateChain(Arrays.asList(chain));
            samlContext.setPeerSSLCredential((X509Credential)credential);
        }
    }

    protected void populateDecrypter(SAMLMessageContext samlContext) {
        Credential encryptionCredential = samlContext.getLocalExtendedMetadata().getEncryptionKey() != null ? this.keyManager.getCredential(samlContext.getLocalExtendedMetadata().getEncryptionKey()) : this.keyManager.getDefaultCredential();
        StaticKeyInfoCredentialResolver resolver = new StaticKeyInfoCredentialResolver(encryptionCredential);
        Decrypter decrypter = new Decrypter(null, (KeyInfoCredentialResolver)resolver, (EncryptedKeyResolver)encryptedKeyResolver);
        decrypter.setRootInNewDocument(true);
        samlContext.setLocalDecrypter(decrypter);
    }

    protected void populateTrustEngine(SAMLMessageContext samlContext) {
        Object engine = "pkix".equalsIgnoreCase(samlContext.getLocalExtendedMetadata().getSecurityProfile()) ? new PKIXSignatureTrustEngine(this.pkixResolver, Configuration.getGlobalSecurityConfiguration().getDefaultKeyInfoCredentialResolver(), this.pkixTrustEvaluator, (X509CredentialNameEvaluator)new BasicX509CredentialNameEvaluator()) : new ExplicitKeySignatureTrustEngine((CredentialResolver)this.metadataResolver, Configuration.getGlobalSecurityConfiguration().getDefaultKeyInfoCredentialResolver());
        samlContext.setLocalTrustEngine((SignatureTrustEngine)engine);
    }

    protected void populateSSLTrustEngine(SAMLMessageContext samlContext) {
        Object engine = "pkix".equalsIgnoreCase(samlContext.getLocalExtendedMetadata().getSslSecurityProfile()) ? new PKIXX509CredentialTrustEngine(this.pkixResolver, this.pkixTrustEvaluator, (X509CredentialNameEvaluator)new BasicX509CredentialNameEvaluator()) : new ExplicitX509CertificateTrustEngine((CredentialResolver)this.metadataResolver);
        samlContext.setLocalSSLTrustEngine((TrustEngine<X509Credential>)engine);
    }

    @Autowired
    public void setMetadata(MetadataManager metadata) {
        this.metadata = metadata;
    }

    @Autowired
    public void setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public void setPkixResolver(PKIXValidationInformationResolver pkixResolver) {
        this.pkixResolver = pkixResolver;
    }

    public void setPkixTrustEvaluator(PKIXTrustEvaluator pkixTrustEvaluator) {
        this.pkixTrustEvaluator = pkixTrustEvaluator;
    }

    public void setMetadataResolver(org.opensaml.security.MetadataCredentialResolver metadataResolver) {
        this.metadataResolver = metadataResolver;
    }

    @Autowired(required=false)
    public void setStorageFactory(SAMLMessageStorageFactory storageFactory) {
        this.storageFactory = storageFactory;
    }

    public void afterPropertiesSet() throws ServletException {
        Assert.notNull((Object)this.keyManager, (String)"Key manager must be set");
        Assert.notNull((Object)this.metadata, (String)"Metadata must be set");
        Assert.notNull((Object)this.storageFactory, (String)"MessageStorageFactory must be set");
        if (this.metadataResolver == null) {
            MetadataCredentialResolver resolver = new MetadataCredentialResolver(this.metadata, this.keyManager);
            resolver.setMeetAllCriteria(false);
            resolver.setUnevaluableSatisfies(true);
            this.metadataResolver = resolver;
        }
        if (this.pkixResolver == null) {
            this.pkixResolver = new PKIXInformationResolver(this.metadataResolver, this.metadata, this.keyManager);
        }
        if (this.pkixTrustEvaluator == null) {
            this.pkixTrustEvaluator = new CertPathPKIXTrustEvaluator();
        }
    }

    static {
        encryptedKeyResolver.getResolverChain().add(new InlineEncryptedKeyResolver());
        encryptedKeyResolver.getResolverChain().add(new EncryptedElementTypeEncryptedKeyResolver());
        encryptedKeyResolver.getResolverChain().add(new SimpleRetrievalMethodEncryptedKeyResolver());
    }
}

