/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scheduler.core;

import java.io.Serializable;
import java.util.Map;
import org.apache.karaf.scheduler.Job;
import org.apache.karaf.scheduler.JobContext;
import org.apache.karaf.scheduler.core.InternalScheduleOptions;
import org.apache.karaf.scheduler.core.KarafStdScheduler;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzJobExecutor
implements org.quartz.Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuartzJobExecutor.class);

    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        KarafStdScheduler scheduler = (KarafStdScheduler)context.getScheduler();
        JobDataMap data = context.getJobDetail().getJobDataMap();
        String contextKey = context.getJobDetail().getKey() != null ? context.getJobDetail().getKey().toString() : null;
        JobDataMap karafContext = contextKey != null ? (JobDataMap)scheduler.getStorage().get((Serializable)((Object)contextKey)) : null;
        org.quartz.Job job = karafContext != null ? karafContext.get("QuartzJobScheduler.Object") : context.getJobInstance();
        Logger logger = karafContext != null ? (Logger)karafContext.get("QuartzJobScheduler.Logger") : LOGGER;
        try {
            logger.debug("Executing job {} with name {}", (Object)job, data.get("QuartzJobScheduler.JobName"));
            if (job instanceof Job) {
                InternalScheduleOptions options = (InternalScheduleOptions)data.get("QuartzJobScheduler.Options");
                String name = (String)data.get("QuartzJobScheduler.JobName");
                JobContextImpl jobCtx = new JobContextImpl(name, options.configuration);
                ((Job)((Object)job)).execute(jobCtx);
            } else if (job instanceof Runnable) {
                ((Runnable)((Object)job)).run();
            } else {
                logger.error("Scheduled job {} is neither a job nor a runnable.", (Object)job);
            }
        }
        catch (Throwable t) {
            logger.error("Exception during job execution of " + job + " : " + t.getMessage(), t);
        }
    }

    public static final class JobContextImpl
    implements JobContext {
        protected final Map<String, Serializable> configuration;
        protected final String name;

        public JobContextImpl(String name, Map<String, Serializable> config) {
            this.name = name;
            this.configuration = config;
        }

        @Override
        public Map<String, Serializable> getConfiguration() {
            return this.configuration;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

