/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.sanitizer;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opennms.systemreport.sanitizer.ConfigFileSanitizer;
import org.opennms.systemreport.sanitizer.FileSanitizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class ConfigurationSanitizer {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationSanitizer.class);
    private final Map<String, ConfigFileSanitizer> sanitizers;

    @Autowired
    public ConfigurationSanitizer(Collection<ConfigFileSanitizer> configFileSanitizerList) {
        HashMap<String, ConfigFileSanitizer> modifiableMap = new HashMap<String, ConfigFileSanitizer>();
        for (ConfigFileSanitizer sanitizer : configFileSanitizerList) {
            modifiableMap.put(sanitizer.getFileName(), sanitizer);
        }
        this.sanitizers = Collections.unmodifiableMap(modifiableMap);
    }

    public Resource getSanitizedResource(File file) {
        ConfigFileSanitizer fileSanitizer = this.getSanitizer(file.getName());
        if (fileSanitizer != null) {
            try {
                return fileSanitizer.getSanitizedResource(file);
            }
            catch (FileSanitizationException e) {
                LOG.error("Could not sanitize file {}: {}", new Object[]{file, e.getCause().getMessage(), e});
                return new ByteArrayResource(e.getMessage().getBytes());
            }
        }
        return new FileSystemResource(file);
    }

    private ConfigFileSanitizer getSanitizer(String fileName) {
        String fileExtension;
        ConfigFileSanitizer fileSanitizer = null;
        if (this.sanitizers.containsKey(fileName)) {
            fileSanitizer = this.sanitizers.get(fileName);
        } else if (fileName.contains(".") && this.sanitizers.containsKey("*" + (fileExtension = fileName.substring(fileName.lastIndexOf("."))))) {
            fileSanitizer = this.sanitizers.get("*" + fileExtension);
        }
        return fileSanitizer;
    }
}

