/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.opennms;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.time.Duration;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.core.resource.Vault;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.TimeSeries;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.systemreport.AbstractSystemReportPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;

public class OpenNMSReportPlugin
extends AbstractSystemReportPlugin
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(OpenNMSReportPlugin.class);
    @Autowired
    public NodeDao m_nodeDao;
    @Autowired
    public IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    public SnmpInterfaceDao m_snmpInterfaceDao;
    @Autowired
    public EventDao m_eventDao;
    @Autowired
    public AlarmDao m_alarmDao;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Override
    public String getName() {
        return "OpenNMS";
    }

    @Override
    public String getDescription() {
        return "OpenNMS core information, version, and basic configuration";
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public int getPriority() {
        return 3;
    }

    @Override
    public Map<String, Resource> getEntries() {
        RuntimeMXBean runtimeBean;
        TreeMap<String, Resource> map = new TreeMap<String, Resource>();
        map.put("OpenNMS Home Dir", this.getResourceFromProperty("opennms.home"));
        map.put("Version", this.getResource(Vault.getProperty((String)"version.display")));
        if (this.m_nodeDao != null) {
            map.put("Number of Nodes", this.getResource(Integer.toString(this.m_nodeDao.countAll())));
        }
        if (this.m_ipInterfaceDao != null) {
            map.put("Number of IP Interfaces", this.getResource(Integer.toString(this.m_ipInterfaceDao.countAll())));
        }
        if (this.m_snmpInterfaceDao != null) {
            map.put("Number of SNMP Interfaces", this.getResource(Integer.toString(this.m_snmpInterfaceDao.countAll())));
        }
        if (this.m_eventDao != null) {
            map.put("Number of Events", this.getResource(Integer.toString(this.m_eventDao.countAll())));
        }
        if (this.m_alarmDao != null) {
            map.put("Number of Alarms", this.getResource(Integer.toString(this.m_alarmDao.countAll())));
        }
        if ((runtimeBean = this.getBean("java.lang:type=Runtime", RuntimeMXBean.class)) == null) {
            LOG.info("falling back to local VM RuntimeMXBean");
            runtimeBean = ManagementFactory.getRuntimeMXBean();
        }
        this.addGetters(runtimeBean, map);
        map.put("OpenNMS Up Time", this.getResource(this.getOnmsUptimeAsString(runtimeBean)));
        map.put("Time-Series Strategy", this.getResource(TimeSeries.getTimeseriesStrategy().getName()));
        return map;
    }

    private String getOnmsUptimeAsString(RuntimeMXBean runtimeBean) {
        long startTimeMillis = runtimeBean.getStartTime();
        long currentTimeMillis = System.currentTimeMillis();
        long uptimeMillis = currentTimeMillis - startTimeMillis;
        Duration uptimeDuration = Duration.ofMillis(uptimeMillis);
        long hours = uptimeDuration.toHours();
        long minutes = uptimeDuration.toMinutes() % 60L;
        long seconds = uptimeDuration.getSeconds() % 60L;
        return String.format("%d hours, %d minutes, %d seconds", hours, minutes, seconds);
    }
}

