/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.icmp6;

import java.nio.ByteBuffer;
import org.opennms.protocols.icmp6.ICMPv6Packet;

public class ICMPv6EchoPacket
extends ICMPv6Packet {
    public static final long COOKIE = 5724186650822398753L;
    public static final int HEADER_OFFSET_IDENTIFIER = 4;
    public static final int HEADER_OFFSET_SEQUENCE_NUMBER = 6;
    public static final int HEADER_LENGTH = 8;
    public static final int DATA_OFFSET_SENTTIME = 0;
    public static final int DATA_OFFSET_RECVTIME = 8;
    public static final int DATA_OFFSET_THREAD_ID = 16;
    public static final int DATA_OFFSET_RTT = 24;
    public static final int DATA_OFFSET_COOKIE = 32;
    public static final int DATA_LENGTH = 40;
    private final ByteBuffer m_dataBuffer;

    public ICMPv6EchoPacket(int size) {
        super(size);
        ByteBuffer content = this.m_packetData.duplicate();
        content.position(8);
        this.m_dataBuffer = content.slice();
    }

    public ICMPv6EchoPacket(ICMPv6Packet icmpPacket) {
        super(icmpPacket);
        ByteBuffer content = this.m_packetData.duplicate();
        content.position(8);
        this.m_dataBuffer = content.slice();
    }

    public ByteBuffer getDataBuffer() {
        return this.m_dataBuffer;
    }

    public int getIdentifier() {
        return this.getUnsignedShort(4);
    }

    public void setIdentifier(int id) {
        this.setUnsignedShort(4, id);
    }

    public int getSequenceNumber() {
        return this.getUnsignedShort(6);
    }

    public void setSequenceNumber(int sn) {
        this.setUnsignedShort(6, sn);
    }

    public long getSentTime() {
        return this.getDataBuffer().getLong(0);
    }

    public void setSentTime(long sentTime) {
        this.getDataBuffer().putLong(0, sentTime);
    }

    public long getReceiveTime() {
        return this.getDataBuffer().getLong(8);
    }

    public void setReceiveTime(long recvTime) {
        this.getDataBuffer().putLong(8, recvTime);
    }

    public long getThreadId() {
        return this.getDataBuffer().getLong(16);
    }

    public void setThreadId(long threadId) {
        this.getDataBuffer().putLong(16, threadId);
    }

    public long getRoundTripTime() {
        return this.getDataBuffer().getLong(24);
    }

    public void setRoundTripTime(long rtt) {
        this.getDataBuffer().putLong(24, rtt);
    }

    public long getCookie() {
        return this.getDataBuffer().getLong(32);
    }

    public void setCookie() {
        this.getDataBuffer().putLong(32, 5724186650822398753L);
    }
}

