/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal.decision;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.opennms.netmgt.flows.classification.ClassificationRequest;
import org.opennms.netmgt.flows.classification.FilterService;
import org.opennms.netmgt.flows.classification.internal.decision.Bound;
import org.opennms.netmgt.flows.classification.internal.decision.Bounds;
import org.opennms.netmgt.flows.classification.internal.decision.PreprocessedRule;
import org.opennms.netmgt.flows.classification.internal.matcher.DstAddressMatcher;
import org.opennms.netmgt.flows.classification.internal.matcher.DstPortMatcher;
import org.opennms.netmgt.flows.classification.internal.matcher.FilterMatcher;
import org.opennms.netmgt.flows.classification.internal.matcher.Matcher;
import org.opennms.netmgt.flows.classification.internal.matcher.ProtocolMatcher;
import org.opennms.netmgt.flows.classification.internal.matcher.SrcAddressMatcher;
import org.opennms.netmgt.flows.classification.internal.matcher.SrcPortMatcher;

public class Classifier
implements Comparable<Classifier> {
    public final Matcher[] matchers;
    public final Result result;
    public final int groupPosition;
    public final int position;

    private static <RV> void addMatcher(List<Matcher> matchers, RV ruleValue, Function<RV, Matcher> matcherCreator) {
        if (ruleValue != null) {
            matchers.add(matcherCreator.apply(ruleValue));
        }
    }

    public static Classifier of(PreprocessedRule rule, FilterService filterService, Bounds bounds) {
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        int matchedAspects = 0;
        if (rule.protocol != null) {
            ++matchedAspects;
            Classifier.addMatcher(matchers, rule.protocol.shrink(bounds.protocol), ProtocolMatcher::new);
        }
        if (rule.srcPort != null) {
            ++matchedAspects;
            Classifier.addMatcher(matchers, rule.srcPort.shrink((Bound)bounds.srcPort), SrcPortMatcher::new);
        }
        if (rule.dstPort != null) {
            ++matchedAspects;
            Classifier.addMatcher(matchers, rule.dstPort.shrink((Bound)bounds.dstPort), DstPortMatcher::new);
        }
        if (rule.srcAddr != null) {
            ++matchedAspects;
            Classifier.addMatcher(matchers, rule.srcAddr.shrink((Bound)bounds.srcAddr), SrcAddressMatcher::new);
        }
        if (rule.dstAddr != null) {
            ++matchedAspects;
            Classifier.addMatcher(matchers, rule.dstAddr.shrink((Bound)bounds.dstAddr), DstAddressMatcher::new);
        }
        if (rule.ruleDefinition.hasExportFilterDefinition()) {
            matchers.add(new FilterMatcher(rule.ruleDefinition.getExporterFilter(), filterService));
        }
        return new Classifier(matchers.toArray(new Matcher[matchers.size()]), new Result(matchedAspects, rule.ruleDefinition.getName()), rule.ruleDefinition.getGroupPosition(), rule.ruleDefinition.getPosition());
    }

    public Classifier(Matcher[] matchers, Result result, int groupPosition, int position) {
        this.matchers = matchers;
        this.result = result;
        this.groupPosition = groupPosition;
        this.position = position;
    }

    public Result classify(ClassificationRequest request) {
        for (Matcher m : this.matchers) {
            if (m.matches(request)) continue;
            return null;
        }
        return this.result;
    }

    @Override
    public int compareTo(Classifier o) {
        return this.groupPosition < o.groupPosition ? -1 : (this.groupPosition > o.groupPosition ? 1 : (this.position < o.position ? -1 : (this.position > o.position ? 1 : 0)));
    }

    public String toString() {
        return "Classifier{result='" + String.valueOf(this.result) + "', groupPosition=" + this.groupPosition + ", position=" + this.position + "}";
    }

    public static class Result {
        public final int matchedAspects;
        public final String name;

        public Result(int matchedAspects, String name) {
            this.matchedAspects = matchedAspects;
            this.name = name;
        }

        public String toString() {
            return "Result{matchedAspects=" + this.matchedAspects + ", name='" + this.name + "'}";
        }
    }
}

