/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.elastic.client.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchRequest {
    private final List<String> indices;
    private final String query;
    private final Map<String, String> parameters;

    public SearchRequest(List<String> indices, String query) {
        this(indices, query, new HashMap<String, String>());
    }

    public SearchRequest(List<String> indices, String query, Map<String, String> parameters) {
        this.indices = indices;
        this.query = query;
        this.parameters = parameters != null ? new HashMap<String, String>(parameters) : new HashMap();
    }

    public static SearchRequest forIndex(String index, String query) {
        return new SearchRequest(List.of(index), query);
    }

    public static SearchRequest forIndices(List<String> indices, String query) {
        return new SearchRequest(indices, query);
    }

    public List<String> getIndices() {
        return this.indices;
    }

    public String getQuery() {
        return this.query;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public SearchRequest addParameter(String key, String value) {
        this.parameters.put(key, value);
        return this;
    }

    public SearchRequest size(int size) {
        return this.addParameter("size", String.valueOf(size));
    }

    public SearchRequest from(int from) {
        return this.addParameter("from", String.valueOf(from));
    }

    public SearchRequest timeout(String timeout) {
        return this.addParameter("timeout", timeout);
    }

    public SearchRequest ignoreUnavailable(boolean ignore) {
        return this.addParameter("ignore_unavailable", String.valueOf(ignore));
    }

    public SearchRequest allowNoIndices(boolean allow) {
        return this.addParameter("allow_no_indices", String.valueOf(allow));
    }
}

