/*
 * Decompiled with CFR 0.152.
 */
package jcifs.ntlmssp.av;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jcifs.CIFSException;
import jcifs.internal.util.SMBUtil;
import jcifs.ntlmssp.av.AvChannelBindings;
import jcifs.ntlmssp.av.AvFlags;
import jcifs.ntlmssp.av.AvPair;
import jcifs.ntlmssp.av.AvSingleHost;
import jcifs.ntlmssp.av.AvTargetName;
import jcifs.ntlmssp.av.AvTimestamp;

public final class AvPairs {
    private AvPairs() {
    }

    public static List<AvPair> decode(byte[] data) throws CIFSException {
        LinkedList<AvPair> pairs = new LinkedList<AvPair>();
        int pos = 0;
        boolean foundEnd = false;
        while (pos + 4 <= data.length) {
            int avId = SMBUtil.readInt2(data, pos);
            int avLen = SMBUtil.readInt2(data, pos + 2);
            pos += 4;
            if (avId == 0) {
                if (avLen != 0) {
                    throw new CIFSException("Invalid avLen for AvEOL");
                }
                foundEnd = true;
                break;
            }
            byte[] raw = new byte[avLen];
            System.arraycopy(data, pos, raw, 0, avLen);
            pairs.add(AvPairs.parseAvPair(avId, raw));
            pos += avLen;
        }
        if (!foundEnd) {
            throw new CIFSException("Missing AvEOL");
        }
        return pairs;
    }

    public static boolean contains(List<AvPair> pairs, int type) {
        if (pairs == null) {
            return false;
        }
        for (AvPair p : pairs) {
            if (p.getType() != type) continue;
            return true;
        }
        return false;
    }

    public static AvPair get(List<AvPair> pairs, int type) {
        for (AvPair p : pairs) {
            if (p.getType() != type) continue;
            return p;
        }
        return null;
    }

    public static void remove(List<AvPair> pairs, int type) {
        Iterator<AvPair> it = pairs.iterator();
        while (it.hasNext()) {
            AvPair p = it.next();
            if (p.getType() != type) continue;
            it.remove();
        }
    }

    public static void replace(List<AvPair> pairs, AvPair rep) {
        AvPairs.remove(pairs, rep.getType());
        pairs.add(rep);
    }

    public static byte[] encode(List<AvPair> pairs) {
        int size = 0;
        for (AvPair p : pairs) {
            size += 4 + p.getRaw().length;
        }
        byte[] enc = new byte[size += 4];
        int pos = 0;
        for (AvPair p : pairs) {
            byte[] raw = p.getRaw();
            SMBUtil.writeInt2(p.getType(), enc, pos);
            SMBUtil.writeInt2(raw.length, enc, pos + 2);
            System.arraycopy(raw, 0, enc, pos + 4, raw.length);
            pos += 4 + raw.length;
        }
        SMBUtil.writeInt2(0L, enc, pos);
        SMBUtil.writeInt2(0L, enc, pos + 2);
        pos += 4;
        return enc;
    }

    private static AvPair parseAvPair(int avId, byte[] raw) {
        switch (avId) {
            case 6: {
                return new AvFlags(raw);
            }
            case 7: {
                return new AvTimestamp(raw);
            }
            case 9: {
                return new AvTargetName(raw);
            }
            case 8: {
                return new AvSingleHost(raw);
            }
            case 10: {
                return new AvChannelBindings(raw);
            }
        }
        return new AvPair(avId, raw);
    }
}

