/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jaxrs.publisher.internal;

import com.eclipsesource.jaxrs.publisher.internal.RootApplication;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Request;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

public class ServletContainerBridge
extends HttpServlet
implements Runnable {
    private final RootApplication application;
    private ServletContainer servletContainer;
    private ServletConfig servletConfig;
    private volatile boolean isJerseyReady;

    public ServletContainerBridge(RootApplication application) {
        this.servletContainer = new ServletContainer(ResourceConfig.forApplication((Application)application));
        this.application = application;
        this.isJerseyReady = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.application.isDirty()) {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(Request.class.getClassLoader());
                ServletContainerBridge servletContainerBridge = this;
                synchronized (servletContainerBridge) {
                    if (!this.isJerseyReady()) {
                        this.getServletContainer().init(this.servletConfig);
                    } else {
                        this.isJerseyReady = false;
                        this.getServletContainer().reload(ResourceConfig.forApplication((Application)this.application));
                    }
                    this.isJerseyReady = true;
                }
            }
            catch (ServletException e) {
                throw new RuntimeException(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
    }

    public void init(ServletConfig config) throws ServletException {
        this.application.setDirty(true);
        this.servletConfig = config;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        if (this.isJerseyReady()) {
            this.getServletContainer().service(req, res);
        } else {
            ((HttpServletResponse)res).sendError(503, "Jersey is not ready yet!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ServletContainerBridge servletContainerBridge = this;
        synchronized (servletContainerBridge) {
            if (this.isJerseyReady()) {
                this.getServletContainer().destroy();
                this.isJerseyReady = false;
                this.servletContainer = new ServletContainer(ResourceConfig.forApplication((Application)this.application));
            }
        }
    }

    ServletContainer getServletContainer() {
        return this.servletContainer;
    }

    boolean isJerseyReady() {
        return this.isJerseyReady;
    }
}

