/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.netflow9.proto;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.InformationElementDatabase;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.netflow9.proto.FieldSpecifier;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.netflow9.proto.OptionsTemplateRecordHeader;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.netflow9.proto.OptionsTemplateSet;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.netflow9.proto.Record;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.netflow9.proto.ScopeFieldSpecifier;

public final class OptionsTemplateRecord
implements Record {
    public final OptionsTemplateSet set;
    public final OptionsTemplateRecordHeader header;
    public final List<ScopeFieldSpecifier> scopes;
    public final List<FieldSpecifier> fields;

    public OptionsTemplateRecord(InformationElementDatabase informationElementDatabase, OptionsTemplateSet set, OptionsTemplateRecordHeader header, ByteBuf buffer) throws InvalidPacketException {
        this.set = Objects.requireNonNull(set);
        this.header = Objects.requireNonNull(header);
        LinkedList<ScopeFieldSpecifier> scopeFields = new LinkedList<ScopeFieldSpecifier>();
        for (int i = 0; i < this.header.optionScopeLength; i += 4) {
            ScopeFieldSpecifier scopeField = new ScopeFieldSpecifier(informationElementDatabase, buffer);
            if (scopeField.fieldLength == 0) continue;
            scopeFields.add(scopeField);
        }
        LinkedList<FieldSpecifier> fields = new LinkedList<FieldSpecifier>();
        for (int i = 0; i < this.header.optionLength; i += 4) {
            FieldSpecifier field = new FieldSpecifier(informationElementDatabase, buffer);
            fields.add(field);
        }
        this.scopes = Collections.unmodifiableList(scopeFields);
        this.fields = Collections.unmodifiableList(fields);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("header", (Object)this.header).add("scopeFields", this.scopes).add("fields", this.fields).toString();
    }
}

