/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class JettyUserIdentityFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(JettyUserIdentityFilter.class);

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            Request jettyReq = Request.getBaseRequest((ServletRequest)req);
            if (jettyReq == null) {
                LOG.warn("Failed to find org.eclipse.jetty.server.Request from javax.servlet.ServletRequest. No identity will be set.");
            } else {
                jettyReq.setAuthentication((org.eclipse.jetty.server.Authentication)new AuthenticationUserStub(authentication));
            }
        }
        chain.doFilter(req, res);
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    private static class AuthenticationUserStub
    implements Authentication.User {
        private final Authentication authentication;

        public AuthenticationUserStub(Authentication authentication) {
            this.authentication = authentication;
        }

        public String getAuthMethod() {
            return null;
        }

        public UserIdentity getUserIdentity() {
            return new UserIdentityStub(this.authentication);
        }

        public boolean isUserInRole(UserIdentity.Scope scope, String role) {
            return false;
        }

        public void logout() {
        }

        public org.eclipse.jetty.server.Authentication logout(ServletRequest request) {
            return null;
        }
    }

    private static class UserIdentityStub
    implements UserIdentity {
        private final Authentication authentication;

        public UserIdentityStub(Authentication authentication) {
            this.authentication = authentication;
        }

        public Subject getSubject() {
            return new Subject();
        }

        public Principal getUserPrincipal() {
            return this.authentication;
        }

        public boolean isUserInRole(String role, UserIdentity.Scope scope) {
            return false;
        }
    }
}

