/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.persistence.api;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpRouter;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpUnicastPrefix;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.State;

@Entity
@Table(name="bmp_peers")
public class BmpPeer
implements Serializable {
    private static final long serialVersionUID = 910756667828959198L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="bmpPeerSequence")
    @SequenceGenerator(name="bmpPeerSequence", sequenceName="bmppeernxtid")
    @Column(name="id", nullable=false)
    private Long id;
    @Column(name="hash_id", nullable=false)
    private String hashId;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="router_hash_id", referencedColumnName="hash_id", nullable=false)
    private BmpRouter bmpRouter;
    @Column(name="peer_rd", nullable=false)
    private String peerRd;
    @Column(name="is_ipv4", nullable=false)
    private boolean isIpv4;
    @Column(name="peer_addr", nullable=false)
    private String peerAddr;
    @Column(name="name")
    private String name;
    @Column(name="peer_bgp_id")
    private String peerBgpId;
    @Column(name="peer_asn")
    private Long peerAsn;
    @Column(name="state", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private State state;
    @Column(name="is_l3vpn_peer", nullable=false)
    private boolean isL3VPNPeer;
    @Column(name="last_updated", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date timestamp;
    @Column(name="is_pre_policy", nullable=false)
    private boolean isPrePolicy;
    @Column(name="geo_ip_start")
    private String geoIpStart;
    @Column(name="local_ip")
    private String localIp;
    @Column(name="local_bgp_id")
    private String localBgpId;
    @Column(name="local_port")
    private Integer localPort;
    @Column(name="local_hold_time")
    private Long localHoldTime;
    @Column(name="local_asn")
    private Long localAsn;
    @Column(name="remote_port")
    private Integer remotePort;
    @Column(name="remote_hold_time")
    private Long remoteHoldTime;
    @Column(name="sent_capabilities")
    private String sentCapabilities;
    @Column(name="recv_capabilities")
    private String receivedCapabilities;
    @Column(name="bmp_reason")
    private Integer bmpReason;
    @Column(name="bgp_err_code")
    private Integer bgpErrCode;
    @Column(name="bgp_err_subcode")
    private Integer bgpErrSubCode;
    @Column(name="error_text")
    private String errorText;
    @Column(name="is_loc_rib", nullable=false)
    private boolean isLocRib;
    @Column(name="is_loc_rib_filtered", nullable=false)
    private boolean isLocRibFiltered;
    @Column(name="table_name")
    private String tableName;
    @OneToMany(mappedBy="bmpPeer", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<BmpUnicastPrefix> bmpUnicastPrefixes = new LinkedHashSet<BmpUnicastPrefix>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getHashId() {
        return this.hashId;
    }

    public void setHashId(String hashId) {
        this.hashId = hashId;
    }

    public BmpRouter getBmpRouter() {
        return this.bmpRouter;
    }

    public void setBmpRouter(BmpRouter bmpRouter) {
        this.bmpRouter = bmpRouter;
    }

    public String getPeerRd() {
        return this.peerRd;
    }

    public void setPeerRd(String peerRd) {
        this.peerRd = peerRd;
    }

    public boolean isIpv4() {
        return this.isIpv4;
    }

    public void setIpv4(boolean ipv4) {
        this.isIpv4 = ipv4;
    }

    public String getPeerAddr() {
        return this.peerAddr;
    }

    public void setPeerAddr(String peerAddr) {
        this.peerAddr = peerAddr;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPeerBgpId() {
        return this.peerBgpId;
    }

    public void setPeerBgpId(String peerBgpId) {
        this.peerBgpId = peerBgpId;
    }

    public Long getPeerAsn() {
        return this.peerAsn;
    }

    public void setPeerAsn(Long peerAsn) {
        this.peerAsn = peerAsn;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public boolean isL3VPNPeer() {
        return this.isL3VPNPeer;
    }

    public void setL3VPNPeer(boolean l3VPNPeer) {
        this.isL3VPNPeer = l3VPNPeer;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public boolean isPrePolicy() {
        return this.isPrePolicy;
    }

    public void setPrePolicy(boolean prePolicy) {
        this.isPrePolicy = prePolicy;
    }

    public String getGeoIpStart() {
        return this.geoIpStart;
    }

    public void setGeoIpStart(String geoIpStart) {
        this.geoIpStart = geoIpStart;
    }

    public String getLocalIp() {
        return this.localIp;
    }

    public void setLocalIp(String localIp) {
        this.localIp = localIp;
    }

    public String getLocalBgpId() {
        return this.localBgpId;
    }

    public void setLocalBgpId(String localBgpId) {
        this.localBgpId = localBgpId;
    }

    public Integer getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(Integer localPort) {
        this.localPort = localPort;
    }

    public Long getLocalHoldTime() {
        return this.localHoldTime;
    }

    public void setLocalHoldTime(Long localHoldTime) {
        this.localHoldTime = localHoldTime;
    }

    public Long getLocalAsn() {
        return this.localAsn;
    }

    public void setLocalAsn(Long localAsn) {
        this.localAsn = localAsn;
    }

    public Integer getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(Integer remotePort) {
        this.remotePort = remotePort;
    }

    public Long getRemoteHoldTime() {
        return this.remoteHoldTime;
    }

    public void setRemoteHoldTime(Long remoteHoldTime) {
        this.remoteHoldTime = remoteHoldTime;
    }

    public String getSentCapabilities() {
        return this.sentCapabilities;
    }

    public void setSentCapabilities(String sentCapabilities) {
        this.sentCapabilities = sentCapabilities;
    }

    public String getReceivedCapabilities() {
        return this.receivedCapabilities;
    }

    public void setReceivedCapabilities(String receivedCapabilities) {
        this.receivedCapabilities = receivedCapabilities;
    }

    public Integer getBmpReason() {
        return this.bmpReason;
    }

    public void setBmpReason(Integer bmpReason) {
        this.bmpReason = bmpReason;
    }

    public Integer getBgpErrCode() {
        return this.bgpErrCode;
    }

    public void setBgpErrCode(Integer bgpErrCode) {
        this.bgpErrCode = bgpErrCode;
    }

    public Integer getBgpErrSubCode() {
        return this.bgpErrSubCode;
    }

    public void setBgpErrSubCode(Integer bgpErrSubCode) {
        this.bgpErrSubCode = bgpErrSubCode;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public void setErrorText(String errorText) {
        this.errorText = errorText;
    }

    public boolean isLocRib() {
        return this.isLocRib;
    }

    public void setLocRib(boolean locRib) {
        this.isLocRib = locRib;
    }

    public boolean isLocRibFiltered() {
        return this.isLocRibFiltered;
    }

    public void setLocRibFiltered(boolean locRibFiltered) {
        this.isLocRibFiltered = locRibFiltered;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Set<BmpUnicastPrefix> getBmpUnicastPrefixes() {
        return this.bmpUnicastPrefixes;
    }

    public void setBmpUnicastPrefixes(Set<BmpUnicastPrefix> bmpUnicastPrefixes) {
        this.bmpUnicastPrefixes.clear();
        this.bmpUnicastPrefixes.addAll(bmpUnicastPrefixes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BmpPeer bmpPeer = (BmpPeer)o;
        return this.isIpv4 == bmpPeer.isIpv4 && this.isL3VPNPeer == bmpPeer.isL3VPNPeer && this.isPrePolicy == bmpPeer.isPrePolicy && this.isLocRib == bmpPeer.isLocRib && this.isLocRibFiltered == bmpPeer.isLocRibFiltered && Objects.equals(this.hashId, bmpPeer.hashId) && Objects.equals(this.bmpRouter, bmpPeer.bmpRouter) && Objects.equals(this.peerRd, bmpPeer.peerRd) && Objects.equals(this.peerAddr, bmpPeer.peerAddr) && Objects.equals(this.name, bmpPeer.name) && Objects.equals(this.peerBgpId, bmpPeer.peerBgpId) && Objects.equals(this.peerAsn, bmpPeer.peerAsn) && this.state == bmpPeer.state && Objects.equals(this.timestamp, bmpPeer.timestamp) && Objects.equals(this.geoIpStart, bmpPeer.geoIpStart) && Objects.equals(this.localIp, bmpPeer.localIp) && Objects.equals(this.localBgpId, bmpPeer.localBgpId) && Objects.equals(this.localPort, bmpPeer.localPort) && Objects.equals(this.localHoldTime, bmpPeer.localHoldTime) && Objects.equals(this.localAsn, bmpPeer.localAsn) && Objects.equals(this.remotePort, bmpPeer.remotePort) && Objects.equals(this.remoteHoldTime, bmpPeer.remoteHoldTime) && Objects.equals(this.sentCapabilities, bmpPeer.sentCapabilities) && Objects.equals(this.receivedCapabilities, bmpPeer.receivedCapabilities) && Objects.equals(this.bmpReason, bmpPeer.bmpReason) && Objects.equals(this.bgpErrCode, bmpPeer.bgpErrCode) && Objects.equals(this.bgpErrSubCode, bmpPeer.bgpErrSubCode) && Objects.equals(this.errorText, bmpPeer.errorText) && Objects.equals(this.tableName, bmpPeer.tableName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hashId, this.bmpRouter, this.peerRd, this.isIpv4, this.peerAddr, this.name, this.peerBgpId, this.peerAsn, this.state, this.isL3VPNPeer, this.timestamp, this.isPrePolicy, this.geoIpStart, this.localIp, this.localBgpId, this.localPort, this.localHoldTime, this.localAsn, this.remotePort, this.remoteHoldTime, this.sentCapabilities, this.receivedCapabilities, this.bmpReason, this.bgpErrCode, this.bgpErrSubCode, this.errorText, this.isLocRib, this.isLocRibFiltered, this.tableName});
    }

    public String toString() {
        return "BmpPeer{id=" + this.id + ", hashId='" + this.hashId + "', peerRd='" + this.peerRd + "', isIpv4=" + this.isIpv4 + ", peerAddr='" + this.peerAddr + "', name='" + this.name + "', peerBgpId='" + this.peerBgpId + "', peerAsn=" + this.peerAsn + ", state=" + String.valueOf((Object)this.state) + ", isL3VPNPeer=" + this.isL3VPNPeer + ", timestamp=" + String.valueOf(this.timestamp) + ", isPrePolicy=" + this.isPrePolicy + ", geoIpStart='" + this.geoIpStart + "', localIp='" + this.localIp + "', localBgpId='" + this.localBgpId + "', localPort=" + this.localPort + ", localHoldTime=" + this.localHoldTime + ", localAsn=" + this.localAsn + ", remotePort=" + this.remotePort + ", remoteHoldTime=" + this.remoteHoldTime + ", sentCapabilities='" + this.sentCapabilities + "', receivedCapabilities='" + this.receivedCapabilities + "', bmpReason=" + this.bmpReason + ", bgpErrCode=" + this.bgpErrCode + ", bgpErrSubCode=" + this.bgpErrSubCode + ", errorText='" + this.errorText + "', isLocRib=" + this.isLocRib + ", isLocRibFiltered=" + this.isLocRibFiltered + ", tableName='" + this.tableName + "', bmpUnicastPrefixes=" + String.valueOf(this.bmpUnicastPrefixes) + "}";
    }
}

