/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.api;

import java.net.InetAddress;
import java.util.Objects;
import java.util.Optional;

public interface InterfaceToNodeCache {
    public void dataSourceSync();

    public boolean setNodeId(String var1, InetAddress var2, int var3);

    public boolean removeNodeId(String var1, InetAddress var2, int var3);

    public int size();

    public void clear();

    public Optional<Entry> getFirst(String var1, InetAddress var2);

    default public Optional<Integer> getFirstNodeId(String location, InetAddress ipAddr) {
        return this.getFirst(location, ipAddr).map(e -> e.nodeId);
    }

    public void removeInterfacesForNode(int var1);

    public static class Entry {
        public final int nodeId;
        public final int interfaceId;

        public Entry(int nodeId, int interfaceId) {
            this.nodeId = nodeId;
            this.interfaceId = interfaceId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)o;
            return this.nodeId == entry.nodeId && this.interfaceId == entry.interfaceId;
        }

        public int hashCode() {
            return Objects.hash(this.nodeId, this.interfaceId);
        }
    }
}

