/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.core.soa.lookup.ServiceLookup;
import org.opennms.core.soa.lookup.ServiceLookupBuilder;
import org.opennms.core.soa.lookup.ServiceRegistryLookup;
import org.opennms.core.soa.support.DefaultServiceRegistry;
import org.opennms.integration.api.v1.timeseries.StorageException;
import org.opennms.integration.api.v1.timeseries.TimeSeriesStorage;
import org.opennms.netmgt.timeseries.TimeseriesStorageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeseriesStorageManagerImpl
implements TimeseriesStorageManager {
    private static final Logger LOG = LoggerFactory.getLogger(TimeseriesStorageManagerImpl.class);
    private CopyOnWriteArrayList<TimeSeriesStorage> stackOfStorages = new CopyOnWriteArrayList();
    private ServiceLookup<Class<?>, String> LOOKUP;

    public TimeseriesStorageManagerImpl() {
        this(new ServiceLookupBuilder((ServiceLookup)new ServiceRegistryLookup((ServiceRegistry)DefaultServiceRegistry.INSTANCE)).blocking(ServiceLookupBuilder.GRACE_PERIOD_MS, ServiceLookupBuilder.LOOKUP_DELAY_MS, 0L).build());
    }

    public TimeseriesStorageManagerImpl(ServiceLookup<Class<?>, String> lookup) {
        this.LOOKUP = Objects.requireNonNull(lookup);
    }

    @Override
    public TimeSeriesStorage get() throws StorageException {
        if (this.stackOfStorages.isEmpty()) {
            TimeSeriesStorage storage = (TimeSeriesStorage)this.LOOKUP.lookup(TimeSeriesStorage.class, null);
            if (storage != null) {
                this.stackOfStorages.addIfAbsent(storage);
            } else {
                LOG.warn("Could not find a TimeSeriesStorage implementation. The collection of metrics won't work properly. Please refer to the documentation: https://docs.opennms.org/opennms/releases/latest/guide-admin/guide-admin.html#ga-opennms-operation-timeseries");
            }
        }
        return Optional.ofNullable(this.getOrNull()).orElseThrow(() -> new StorageException("No timeseries storage implementation found"));
    }

    private TimeSeriesStorage getOrNull() {
        return this.stackOfStorages.isEmpty() ? null : this.stackOfStorages.get(this.stackOfStorages.size() - 1);
    }

    public synchronized void onBind(TimeSeriesStorage storage, Map properties) {
        LOG.debug("Bind called with {}: {}", (Object)storage, (Object)properties);
        TimeSeriesStorage currentStorage = this.getOrNull();
        if (storage != null && this.stackOfStorages.addIfAbsent(storage)) {
            LOG.info("Found new TimeSeriesStorage {}, will replace the existing one: {}", (Object)storage, (Object)currentStorage);
        }
    }

    public synchronized void onUnbind(TimeSeriesStorage storage, Map properties) {
        LOG.debug("Unbind called with {}: {}", (Object)storage, (Object)properties);
        if (storage != null && this.stackOfStorages.remove(storage)) {
            TimeSeriesStorage currentStorage = this.getOrNull();
            LOG.info("Remove TimeSeriesStorage {}, it will be replaced by: {}", (Object)storage, (Object)currentStorage);
        }
    }
}

