/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.load;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonNodeReader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.core.load.download.URIDownloader;
import com.github.fge.jsonschema.core.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;

public final class URIManager {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    private final Map<String, URIDownloader> downloaders;
    private final JsonNodeReader reader;

    public URIManager() {
        this(LoadingConfiguration.byDefault());
    }

    public URIManager(LoadingConfiguration cfg) {
        this.downloaders = cfg.getDownloaderMap();
        this.reader = cfg.getReader();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonNode getContent(URI uri) throws ProcessingException {
        BUNDLE.checkNotNull((Object)uri, "jsonRef.nullURI");
        if (!uri.isAbsolute()) {
            throw new ProcessingException(new ProcessingMessage().setMessage(BUNDLE.getMessage("refProcessing.uriNotAbsolute")).put("uri", uri));
        }
        String scheme = uri.getScheme();
        URIDownloader downloader = this.downloaders.get(scheme);
        if (downloader == null) {
            throw new ProcessingException(new ProcessingMessage().setMessage(BUNDLE.getMessage("refProcessing.unhandledScheme")).putArgument("scheme", scheme).putArgument("uri", uri));
        }
        try {
            Throwable throwable = null;
            try (Closer closer = Closer.create();){
                InputStream in = (InputStream)closer.register((Closeable)downloader.fetch(uri));
                JsonNode jsonNode = this.reader.fromInputStream(in);
                return jsonNode;
            }
            catch (JsonMappingException e) {
                try {
                    throw new ProcessingException(new ProcessingMessage().setMessage(e.getOriginalMessage()).put("uri", uri));
                    catch (JsonParseException e2) {
                        throw new ProcessingException(new ProcessingMessage().setMessage(BUNDLE.getMessage("uriManager.uriNotJson")).putArgument("uri", uri).put("parsingMessage", e2.getOriginalMessage()));
                    }
                    catch (IOException e3) {
                        throw new ProcessingException(new ProcessingMessage().setMessage(BUNDLE.getMessage("uriManager.uriIOError")).putArgument("uri", uri).put("exceptionMessage", e3.getMessage()));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

