/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.query.JRClauseFunction;
import net.sf.jasperreports.engine.util.Pair;

final class TypesCandidateComparator
implements Comparator<Pair<List<Class<?>>, JRClauseFunction>> {
    public static final String EXCEPTION_MESSAGE_KEY_QUERY_PARAMETER_TYPE_SELECTOR_CANDIDATE_TYPE_SIZE_MISMATCH = "query.parameter.type.selector.candidate.type.size.mismatch";
    protected static final TypesCandidateComparator INSTANCE = new TypesCandidateComparator();

    private TypesCandidateComparator() {
    }

    @Override
    public int compare(Pair<List<Class<?>>, JRClauseFunction> o1, Pair<List<Class<?>>, JRClauseFunction> o2) {
        List<Class<?>> types1 = o1.first();
        List<Class<?>> types2 = o2.first();
        if (types1.size() != types2.size()) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_QUERY_PARAMETER_TYPE_SELECTOR_CANDIDATE_TYPE_SIZE_MISMATCH, types1.size(), types2.size());
        }
        int order = 0;
        Iterator<Class<?>> it1 = types1.iterator();
        Iterator<Class<?>> it2 = types2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            Class<?> type2;
            Class<?> type1 = it1.next();
            int typesOrder = this.compareTypes(type1, type2 = it2.next());
            if (typesOrder == 0) continue;
            order = typesOrder;
            break;
        }
        return order;
    }

    protected int compareTypes(Class<?> type1, Class<?> type2) {
        if (type1.equals(type2)) {
            return 0;
        }
        if (type1.isAssignableFrom(type2)) {
            return 1;
        }
        if (type2.isAssignableFrom(type1)) {
            return -1;
        }
        return type1.getName().compareTo(type2.getName());
    }
}

