/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.HtmlFontFamily;
import net.sf.jasperreports.engine.export.HtmlFontUtil;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;
import net.sf.jasperreports.engine.export.JRHtmlExporterContext;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.fonts.FontSetInfo;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.export.HtmlExporterConfiguration;
import net.sf.jasperreports.export.HtmlExporterOutput;
import net.sf.jasperreports.export.HtmlReportConfiguration;

public abstract class AbstractHtmlExporter<RC extends HtmlReportConfiguration, C extends HtmlExporterConfiguration>
extends JRAbstractExporter<RC, C, HtmlExporterOutput, JRHtmlExporterContext> {
    protected static final String CSS_TEXT_ALIGN_LEFT = "left";
    protected static final String CSS_TEXT_ALIGN_RIGHT = "right";
    protected static final String CSS_TEXT_ALIGN_CENTER = "center";
    protected static final String CSS_TEXT_ALIGN_JUSTIFY = "justify";
    protected static final String HTML_VERTICAL_ALIGN_TOP = "top";
    protected static final String HTML_VERTICAL_ALIGN_MIDDLE = "middle";
    protected static final String HTML_VERTICAL_ALIGN_BOTTOM = "bottom";
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    protected static final String JR_BOOKMARK_ANCHOR_PREFIX = "JR_BKMRK_";
    protected static final float DEFAULT_ZOOM = 1.0f;
    public static final String IMAGE_NAME_PREFIX = "img_";
    protected static final int IMAGE_NAME_PREFIX_LEGTH = "img_".length();
    protected HtmlResourceHandler imageHandler;
    protected HtmlResourceHandler fontHandler;
    protected HtmlResourceHandler resourceHandler;
    protected Map<String, HtmlFontFamily> fontsToProcess;

    public AbstractHtmlExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    public HtmlResourceHandler getImageHandler() {
        return this.imageHandler;
    }

    public void setImageHandler(HtmlResourceHandler imageHandler) {
        this.imageHandler = imageHandler;
    }

    public HtmlResourceHandler getFontHandler() {
        return this.fontHandler;
    }

    public void setFontHandler(HtmlResourceHandler fontHandler) {
        this.fontHandler = fontHandler;
    }

    public HtmlResourceHandler getResourceHandler() {
        return this.resourceHandler;
    }

    public void setResourceHandler(HtmlResourceHandler resourceHandler) {
        this.resourceHandler = resourceHandler;
    }

    public static JRPrintImage getImage(List<JasperPrint> jasperPrintList, String imageName) {
        return AbstractHtmlExporter.getImage(jasperPrintList, AbstractHtmlExporter.getPrintElementIndex(imageName));
    }

    public static String getImageName(JRPrintElementIndex printElementIndex) {
        return AbstractHtmlExporter.getImageName(printElementIndex, null);
    }

    public static String getImageName(JRPrintElementIndex printElementIndex, String fileExtension) {
        return IMAGE_NAME_PREFIX + printElementIndex.toString() + (fileExtension == null ? "" : "." + fileExtension);
    }

    public static JRPrintImage getImage(List<JasperPrint> jasperPrintList, JRPrintElementIndex imageIndex) {
        JasperPrint report = jasperPrintList.get(imageIndex.getReportIndex());
        JRPrintPage page = report.getPages().get(imageIndex.getPageIndex());
        Integer[] elementIndexes = imageIndex.getAddressArray();
        JRPrintElement element = page.getElements().get(elementIndexes[0]);
        for (int i = 1; i < elementIndexes.length; ++i) {
            JRPrintFrame frame = (JRPrintFrame)element;
            element = frame.getElements().get(elementIndexes[i]);
        }
        return (JRPrintImage)element;
    }

    public static JRPrintElementIndex getPrintElementIndex(String imageName) {
        if (!imageName.startsWith(IMAGE_NAME_PREFIX)) {
            throw new JRRuntimeException("export.common.invalid.image.name", imageName);
        }
        int fileExtensionStart = imageName.lastIndexOf(46);
        fileExtensionStart = fileExtensionStart < 0 ? imageName.length() : fileExtensionStart;
        return JRPrintElementIndex.parsePrintElementIndex(imageName.substring(IMAGE_NAME_PREFIX_LEGTH, fileExtensionStart));
    }

    protected String resolveFontFamily(Map<AttributedCharacterIterator.Attribute, Object> attributes, Locale locale) {
        String handlerFamily;
        String defaultFontFamily;
        String fontFamilyAttr = (String)attributes.get(TextAttribute.FAMILY);
        FontInfo fontInfo = (FontInfo)attributes.get(JRTextAttribute.FONT_INFO);
        if (fontInfo == null) {
            defaultFontFamily = fontFamilyAttr;
            fontInfo = this.fontUtil.getFontInfo(fontFamilyAttr, locale);
        } else {
            defaultFontFamily = fontInfo.getFontFamily().getName();
        }
        String exportFont = null;
        if (fontInfo == null) {
            FontSetInfo fontSetInfo = this.fontUtil.getFontSetInfo(fontFamilyAttr, locale, true);
            if (fontSetInfo != null) {
                exportFont = fontSetInfo.getFontSet().getExportFont(this.getExporterKey());
            }
        } else {
            exportFont = fontInfo.getFontFamily().getExportFont(this.getExporterKey());
        }
        String fontFamily = defaultFontFamily;
        if (exportFont != null) {
            fontFamily = exportFont;
        } else if (fontInfo != null && (handlerFamily = this.handleFont(fontInfo, locale)) != null) {
            fontFamily = handlerFamily + ", '" + fontFamily + "'";
        }
        return fontFamily;
    }

    public String getFontFamily(boolean ignoreCase, String fontFamily, Locale locale) {
        FontInfo fontInfo = FontUtil.getInstance(this.jasperReportsContext).getFontInfo(fontFamily, ignoreCase, locale);
        String htmlFamily = fontFamily;
        if (fontInfo != null) {
            FontFamily family = fontInfo.getFontFamily();
            String exportFont = family.getExportFont(this.getExporterKey());
            if (exportFont == null) {
                String handlerFamily = this.handleFont(fontInfo, locale);
                if (handlerFamily != null) {
                    htmlFamily = handlerFamily;
                }
            } else {
                htmlFamily = exportFont;
            }
        }
        return htmlFamily;
    }

    protected String handleFont(FontInfo fontInfo, Locale locale) {
        HtmlFontFamily htmlFontFamily;
        HtmlExporterOutput output = (HtmlExporterOutput)this.getExporterOutput();
        HtmlResourceHandler resourceHandler = output.getResourceHandler() == null ? this.getResourceHandler() : output.getResourceHandler();
        String family = null;
        if (resourceHandler != null && (htmlFontFamily = HtmlFontFamily.getInstance(locale, fontInfo)) != null) {
            this.addFontFamily(htmlFontFamily);
            family = "'" + htmlFontFamily.getShortId() + "'";
        }
        return family;
    }

    public void addFontFamily(HtmlFontFamily htmlFontFamily) {
        if (!this.fontsToProcess.containsKey(htmlFontFamily.getId())) {
            this.fontsToProcess.put(htmlFontFamily.getId(), htmlFontFamily);
            if (this.getReportContext() == null) {
                HtmlExporterOutput output = (HtmlExporterOutput)this.getExporterOutput();
                HtmlResourceHandler resourceHandler = output.getResourceHandler() == null ? this.getResourceHandler() : output.getResourceHandler();
                HtmlFontUtil.getInstance(this.jasperReportsContext).handleHtmlFont(resourceHandler, null, resourceHandler, htmlFontFamily, true, true);
            }
        }
    }

    protected boolean isOverrideHints() {
        Boolean overrideHints = ((HtmlReportConfiguration)this.getCurrentItemConfiguration()).isOverrideHints();
        return overrideHints != null ? overrideHints.booleanValue() : this.propertiesUtil.getBooleanProperty("net.sf.jasperreports.export.configuration.override.report.hints");
    }

    protected boolean isEmbedImage(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.html.embed.image") && !this.isOverrideHints()) {
            return this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.html.embed.image", (boolean)((HtmlReportConfiguration)this.getCurrentItemConfiguration()).isEmbedImage());
        }
        return ((HtmlReportConfiguration)this.getCurrentItemConfiguration()).isEmbedImage();
    }

    protected boolean isEmbeddedSvgUseFonts(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.html.embedded.svg.use.fonts")) {
            return this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.html.embedded.svg.use.fonts", (boolean)((HtmlReportConfiguration)this.getCurrentItemConfiguration()).isEmbeddedSvgUseFonts());
        }
        return ((HtmlReportConfiguration)this.getCurrentItemConfiguration()).isEmbeddedSvgUseFonts();
    }

    protected boolean isConvertSvgToImage(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.html.convert.svg.to.image") && !this.isOverrideHints()) {
            return this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.html.convert.svg.to.image", (boolean)((HtmlReportConfiguration)this.getCurrentItemConfiguration()).isConvertSvgToImage());
        }
        return ((HtmlReportConfiguration)this.getCurrentItemConfiguration()).isConvertSvgToImage();
    }

    protected boolean isUseBackgroundImageToAlign(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.html.use.background.image.to.align") && !this.isOverrideHints()) {
            return this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.html.use.background.image.to.align", (boolean)((HtmlReportConfiguration)this.getCurrentItemConfiguration()).isUseBackgroundImageToAlign());
        }
        return ((HtmlReportConfiguration)this.getCurrentItemConfiguration()).isUseBackgroundImageToAlign();
    }

    @Override
    protected JRStyledText getStyledText(JRPrintText textElement, boolean setBackcolor) {
        short[] lineBreakOffsets;
        JRStyledText styledText = this.styledTextUtil.getProcessedStyledText(textElement, setBackcolor ? this.allSelector : this.noBackcolorSelector, this.getExporterKey());
        if (styledText != null && (lineBreakOffsets = textElement.getLineBreakOffsets()) != null && lineBreakOffsets.length > 0) {
            styledText = styledText.cloneText();
            styledText.insert("\u0085", lineBreakOffsets);
        }
        return styledText;
    }
}

