/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.snmpmetadata;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.opennms.netmgt.model.OnmsMetaData;
import org.opennms.netmgt.model.snmpmetadata.SnmpMetadataBase;
import org.opennms.netmgt.model.snmpmetadata.SnmpMetadataEntry;
import org.opennms.netmgt.model.snmpmetadata.SnmpMetadataTable;
import org.opennms.netmgt.model.snmpmetadata.SnmpMetadataValue;

@XmlRootElement(name="snmp-metadata-object")
public class SnmpMetadataObject
extends SnmpMetadataBase {
    @XmlTransient
    static final Pattern PATTERN_KEY = Pattern.compile("[^.]+\\[[^\\[]+\\]|[^.]+|[^.]+$");
    @XmlTransient
    static final Pattern PATTERN_INDEX = Pattern.compile("(.*)\\[(.*)\\]$");
    private String name;
    private List<SnmpMetadataObject> objects = new ArrayList<SnmpMetadataObject>();
    private List<SnmpMetadataValue> values = new ArrayList<SnmpMetadataValue>();
    private List<SnmpMetadataTable> tables = new ArrayList<SnmpMetadataTable>();

    public SnmpMetadataObject() {
    }

    public SnmpMetadataObject(String name) {
        this.name = this.trimName(name);
    }

    @XmlAttribute(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name="snmp-metadata-object")
    public List<SnmpMetadataObject> getObjects() {
        return this.objects;
    }

    public void setObjects(List<SnmpMetadataObject> objects) {
        this.objects = objects;
    }

    @XmlElement(name="snmp-metadata-value")
    public List<SnmpMetadataValue> getValues() {
        return this.values;
    }

    public void setValues(List<SnmpMetadataValue> values) {
        this.values = values;
    }

    @XmlElement(name="snmp-metadata-table")
    public List<SnmpMetadataTable> getTables() {
        return this.tables;
    }

    public void setTables(List<SnmpMetadataTable> tables) {
        this.tables = tables;
    }

    public SnmpMetadataObject addObject(String name) {
        SnmpMetadataObject snmpMetadataObject;
        Optional<SnmpMetadataObject> optionalEntry = this.objects.stream().filter(e -> this.trimName(name).equals(e.getName())).findAny();
        if (optionalEntry.isPresent()) {
            snmpMetadataObject = optionalEntry.get();
        } else {
            snmpMetadataObject = new SnmpMetadataObject(name);
            snmpMetadataObject.setParent(this);
            this.objects.add(snmpMetadataObject);
        }
        return snmpMetadataObject;
    }

    public SnmpMetadataTable addTable(String name) {
        SnmpMetadataTable snmpMetadataTable;
        Optional<SnmpMetadataTable> optionalEntry = this.tables.stream().filter(e -> this.trimName(name).equals(e.getName())).findAny();
        if (optionalEntry.isPresent()) {
            snmpMetadataTable = optionalEntry.get();
        } else {
            snmpMetadataTable = new SnmpMetadataTable(name);
            snmpMetadataTable.setParent(this);
            this.tables.add(snmpMetadataTable);
        }
        return snmpMetadataTable;
    }

    public SnmpMetadataValue addValue(String name, String value) {
        SnmpMetadataValue snmpMetadataValue;
        Optional<SnmpMetadataValue> optionalEntry = this.values.stream().filter(e -> this.trimName(name).equals(e.getName())).findAny();
        if (optionalEntry.isPresent()) {
            snmpMetadataValue = optionalEntry.get();
        } else {
            snmpMetadataValue = new SnmpMetadataValue(name);
            snmpMetadataValue.setParent(this);
            this.values.add(snmpMetadataValue);
        }
        snmpMetadataValue.setValue(value);
        return snmpMetadataValue;
    }

    public static SnmpMetadataBase fromOnmsMetadata(List<OnmsMetaData> onmsMetaData, String context) {
        Map<String, String> map = onmsMetaData.stream().filter(m -> context.equals(m.getContext())).collect(Collectors.toMap(OnmsMetaData::getKey, OnmsMetaData::getValue));
        return SnmpMetadataObject.createStructuredMetaData(new SnmpMetadataObject(context), map, null);
    }

    private static SnmpMetadataBase createStructuredMetaData(SnmpMetadataBase structure, Map<String, String> data, String prefix) {
        Set prefixes = Sets.newConcurrentHashSet();
        if (data.containsKey(prefix)) {
            if (structure instanceof SnmpMetadataObject) {
                ((SnmpMetadataObject)structure).addValue(prefix, data.get(prefix));
            }
            if (structure instanceof SnmpMetadataEntry) {
                ((SnmpMetadataEntry)structure).addValue(prefix, data.get(prefix));
            }
            return structure;
        }
        for (Map.Entry<String, String> dataEntry : data.entrySet()) {
            Matcher matcher;
            String key = dataEntry.getKey();
            if (!Strings.isNullOrEmpty((String)prefix)) {
                if (!dataEntry.getKey().startsWith(prefix)) continue;
                if (key.length() > prefix.length() + 1) {
                    key = key.substring(prefix.length() + 1);
                }
            }
            if (!(matcher = PATTERN_KEY.matcher(key)).find() || Strings.isNullOrEmpty((String)matcher.group())) continue;
            prefixes.add(matcher.group());
        }
        for (String p : prefixes) {
            String newPrefix;
            Matcher matcher = PATTERN_INDEX.matcher(p);
            if (matcher.find()) {
                newPrefix = (String)(prefix == null ? "" : prefix + ".") + matcher.group(1);
                prefixes.removeIf(e -> e.startsWith(matcher.group(1)) && PATTERN_INDEX.matcher((CharSequence)e).find());
                SnmpMetadataTable table = ((SnmpMetadataObject)structure).addTable(matcher.group(1));
                for (Map.Entry<String, String> dataEntry : data.entrySet()) {
                    String key = dataEntry.getKey();
                    if (!Strings.isNullOrEmpty((String)newPrefix)) {
                        if (!key.startsWith(newPrefix)) continue;
                        if (key.length() > newPrefix.length()) {
                            key = key.substring(newPrefix.length() + 1).split("\\].")[0];
                        }
                    }
                    SnmpMetadataEntry entry = table.addEntry(key);
                    String prefixAndKey = (String)newPrefix + "[" + key + "]";
                    SnmpMetadataObject.createStructuredMetaData(entry, data.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefixAndKey)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue())), prefixAndKey);
                }
                continue;
            }
            newPrefix = (String)(prefix == null ? "" : prefix + ".") + p;
            if (structure instanceof SnmpMetadataObject) {
                SnmpMetadataObject.createStructuredMetaData(((SnmpMetadataObject)structure).addObject(p), data.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(newPrefix)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue())), newPrefix);
            }
            if (!(structure instanceof SnmpMetadataEntry)) continue;
            SnmpMetadataObject.createStructuredMetaData(structure, data.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(newPrefix)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue())), newPrefix);
        }
        return structure;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SnmpMetadataObject that = (SnmpMetadataObject)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.objects, that.objects) && Objects.equals(this.values, that.values) && Objects.equals(this.tables, that.tables);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.objects, this.values, this.tables);
    }
}

